/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.model.F3PMTimeExpenseLine;
import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_S_TimeExpenseLine;
import org.compiere.util.Env;

public class TimeExpenseValidator
extends AbstractBoostrappableValidator {
    @Override
    public String docValidate(PO arg0, int arg1) {
        return null;
    }

    @Override
    public String login(int arg0, int arg1, int arg2) {
        return null;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        super.initialize(engine, mClient);
        this.addModelChange(engine, "S_TimeExpenseLine");
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        if (model instanceof X_S_TimeExpenseLine && (nType == 2 || nType == 1)) {
            MTimeExpenseLine mTELine = (MTimeExpenseLine)model;
            if (nType == 1 || model.is_ValueChanged("F3P_IsPrePaid") || model.is_ValueChanged("ExpensePrepayAmt") || model.is_ValueChanged("IsTimeReport") || model.is_ValueChanged("C_Currency_ID")) {
                if (F3PMTimeExpenseLine.getF3P_IsPrePaid(mTELine) == null || F3PMTimeExpenseLine.getF3P_IsPrePaid(mTELine).equals("N") || mTELine.isTimeReport()) {
                    F3PMTimeExpenseLine.setExpensePrepayAmt(mTELine, Env.ZERO);
                    F3PMTimeExpenseLine.setPrepayConvertedAmt(mTELine, Env.ZERO);
                } else {
                    BigDecimal bdPrepayAmount = F3PMTimeExpenseLine.getExpensePrepayAmt(mTELine);
                    if (mTELine.getC_Currency_ID() == mTELine.getC_Currency_Report_ID()) {
                        F3PMTimeExpenseLine.setPrepayConvertedAmt(mTELine, bdPrepayAmount);
                    } else {
                        BigDecimal bdConverted = MConversionRate.convert(mTELine.getCtx(), bdPrepayAmount, mTELine.getC_Currency_ID(), mTELine.getC_Currency_Report_ID(), mTELine.getDateExpense(), 0, mTELine.getAD_Client_ID(), mTELine.getAD_Org_ID());
                        F3PMTimeExpenseLine.setPrepayConvertedAmt(mTELine, bdConverted);
                    }
                }
            }
        }
        return null;
    }
}

