/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.OrderCopy;
import com.f3p.adempiere.util.ModelFactory;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.compiere.model.DefaultOrderCopy;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;

public class OrderCopyOperation {
    public static final int PRI_HIGH = 0;
    public static final int PRI_MED = 1;
    public static final int PRI_LOW = 2;
    public static final int HEAD = 0;
    public static final int TAIL = 1;
    public static final Integer ZERO = new Integer(0);
    private static PriorityOpList s_lstOrderCopyChain = new PriorityOpList();
    public static Vector<PO> s_vPOCopied = new Vector();

    static {
        OrderCopyOperation.appendToOperation(new DefaultOrderCopy(), 0, 0);
    }

    public static void appendToOperation(OrderCopy orderCopy) {
        s_lstOrderCopyChain.add(orderCopy, 2, 1);
    }

    public static void appendToOperation(OrderCopy orderCopy, int iPri, int iHeadOrTail) {
        s_lstOrderCopyChain.add(orderCopy, iPri, iHeadOrTail);
    }

    public static List<OrderCopy> getOrderCopyClass() {
        return s_lstOrderCopyChain.getList();
    }

    public static MOrder copyFrom(MOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, boolean copyASI, String trxName) {
        MOrder newOrder = (MOrder)ModelFactory.createModel(from.getCtx(), "C_Order", trxName);
        OrderCopyOperation.addSavedFromCopy(newOrder);
        try {
            List<OrderCopy> lstOps = OrderCopyOperation.getOrderCopyClass();
            PO.copyValues(from, newOrder);
            for (OrderCopy copy : lstOps) {
                copy.copyHeader(from, newOrder, dateDoc, C_DocTypeTarget_ID, isSOTrx, counter);
            }
            if (!newOrder.save()) {
                throw new IllegalStateException("Could not create Order");
            }
            if (counter) {
                from.setRef_Order_ID(newOrder.getC_Order_ID());
            }
            OrderCopyOperation.copyLinesFrom(from, newOrder, counter, copyASI, lstOps);
        }
        finally {
            OrderCopyOperation.removeSavedFromCopy(newOrder);
        }
        return newOrder;
    }

    public static int copyLinesFrom(MOrder from, MOrder to, boolean counter, boolean copyASI) {
        return OrderCopyOperation.copyLinesFrom(from, to, counter, copyASI, null);
    }

    private static int copyLinesFrom(MOrder from, MOrder to, boolean counter, boolean copyASI, List<OrderCopy> lstOps) {
        MOrderLine[] fromLines = from.getLines(false, null);
        int no = 0;
        if (lstOps == null) {
            lstOps = OrderCopyOperation.getOrderCopyClass();
        }
        MOrderLine[] mOrderLineArray = fromLines;
        int n = fromLines.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLine line = mOrderLineArray[n2];
            MOrderLine newOrderLine = (MOrderLine)ModelFactory.createModel(from.getCtx(), "C_OrderLine", to.get_TrxName());
            OrderCopyOperation.addSavedFromCopy(newOrderLine);
            try {
                PO.copyValues(line, newOrderLine);
                newOrderLine.setC_Order_ID(to.getC_Order_ID());
                for (OrderCopy copy : lstOps) {
                    copy.copyLine(line, newOrderLine, counter, copyASI);
                }
                newOrderLine.saveEx();
                ++no;
            }
            finally {
                OrderCopyOperation.removeSavedFromCopy(newOrderLine);
            }
            ++n2;
        }
        return no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addSavedFromCopy(PO po) {
        Vector<PO> vector = s_vPOCopied;
        synchronized (vector) {
            s_vPOCopied.add(po);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeSavedFromCopy(PO po) {
        Vector<PO> vector = s_vPOCopied;
        synchronized (vector) {
            ListIterator<PO> it = s_vPOCopied.listIterator();
            while (it.hasNext()) {
                PO o = it.next();
                if (o != po) continue;
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSavedFromCopy(PO po) {
        Vector<PO> vector = s_vPOCopied;
        synchronized (vector) {
            PO o;
            Iterator<PO> iterator = s_vPOCopied.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((o = iterator.next()) != po);
            return true;
        }
    }

    private static class PriorityOpList {
        private List<OrderCopy> m_low = new LinkedList<OrderCopy>();
        private List<OrderCopy> m_med = new LinkedList<OrderCopy>();
        private List<OrderCopy> m_high = new LinkedList<OrderCopy>();

        private PriorityOpList() {
        }

        public synchronized void add(OrderCopy orderCopy, int iPri, int iOrder) {
            List<OrderCopy> list = null;
            switch (iPri) {
                case 0: {
                    list = this.m_high;
                    break;
                }
                case 1: {
                    list = this.m_med;
                    break;
                }
                default: {
                    list = this.m_low;
                }
            }
            if (iOrder == 0) {
                list.add(0, orderCopy);
            } else {
                list.add(orderCopy);
            }
        }

        public synchronized List<OrderCopy> getList() {
            LinkedList<OrderCopy> lstFull = new LinkedList<OrderCopy>(this.m_high);
            lstFull.addAll(this.m_med);
            lstFull.addAll(this.m_low);
            return lstFull;
        }
    }
}

