/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.model.X_F3P_ReportInt;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MReportInt
extends X_F3P_ReportInt {
    private static final long serialVersionUID = 1L;
    public static final String TAG_SEPARATOR = ",";
    private static CLogger s_log = CLogger.getCLogger(MReportInt.class);

    public MReportInt(Properties ctx, int F3P_ReportInt_ID, String trxName) {
        super(ctx, F3P_ReportInt_ID, trxName);
    }

    public MReportInt(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MReportInt getFromProcess(int AD_Process_ID, String sTrxName) {
        String sQuery = "SELECT F3P_ReportInt.* FROM F3P_ReportInt INNER JOIN AD_Process on AD_Process.F3P_ReportInt_ID = F3P_ReportInt.F3P_ReportInt_ID  WHERE F3P_ReportInt.IsActive = 'Y' AND AD_Process.AD_Process_ID = ? ";
        MReportInt ret = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sQuery, sTrxName);
            pstmt.setInt(1, AD_Process_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = new MReportInt(Env.getCtx(), rs, sTrxName);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "MReportInt.getFromProcess", e);
        }
        return ret;
    }

    public static Collection<String> splitTag(String sTag) {
        ArrayList<String> out = new ArrayList<String>();
        if (sTag != null && sTag.length() > 0) {
            StringTokenizer st = new StringTokenizer(sTag, TAG_SEPARATOR);
            while (st.hasMoreElements()) {
                out.add(st.nextToken());
            }
        }
        return out;
    }

    public MReportDet[] getDetails(String sTipo, int WindowNo, int TabNo, String sTagFilter, boolean bFirstOnly) {
        return this.getDetails(sTipo, WindowNo, TabNo, sTagFilter, bFirstOnly, false);
    }

    public MReportDet[] getDetails(String sTipo, int WindowNo, int TabNo, String sTagFilter, boolean bFirstOnly, boolean bTryUppercaseVars) {
        ArrayList<MReportDet> listDet = new ArrayList<MReportDet>();
        String sQuery = "SELECT * FROM F3P_ReportDet WHERE ISACTIVE = 'Y' AND F3P_ReportInt_ID = ? AND Tipo = ? ORDER BY SeqNo ASC";
        Collection<String> lstTag = MReportInt.splitTag(sTagFilter);
        try {
            sQuery = MRole.getDefault().addAccessSQL(sQuery, "F3P_ReportDet", true, false);
            CPreparedStatement pstmt = DB.prepareStatement(sQuery, this.get_TrxName());
            pstmt.setInt(1, this.getF3P_ReportInt_ID());
            pstmt.setString(2, sTipo);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MReportDet det = new MReportDet(this.getCtx(), rs, this.get_TrxName());
                if (!det.checkIfApplicable(WindowNo, TabNo, lstTag, bTryUppercaseVars)) continue;
                listDet.add(det);
                if (bFirstOnly) break;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "MReportInt.getDetails", e);
        }
        return listDet.toArray(new MReportDet[0]);
    }
}

