/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.MReportDef;
import com.f3p.adempiere.model.MReportInt;
import com.f3p.adempiere.model.X_F3P_ReportDet;
import com.f3p.commons.FileStreamUtils;
import com.f3p.commons.JDBCUtils;
import com.f3p.commons.Utils;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MReportDet
extends X_F3P_ReportDet {
    private static final long serialVersionUID = 1L;
    private static final String SQL_GET_DEF = "SELECT * FROM F3P_ReportDef WHERE F3P_ReportDef_ID = ?";
    protected MReportDef m_reportDef = null;

    public MReportDet(Properties ctx, int F3P_ReportDet_ID, String trxName) {
        super(ctx, F3P_ReportDet_ID, trxName);
    }

    public MReportDet(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MReportDef getDefinition() throws SQLException {
        if (this.m_reportDef == null && this.getF3P_ReportDef_ID() > 0) {
            CPreparedStatement pstmt = DB.prepareStatement(SQL_GET_DEF, this.get_TrxName());
            ResultSet rs = null;
            try {
                pstmt.setInt(1, this.getF3P_ReportDef_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_reportDef = new MReportDef(this.getCtx(), rs, this.get_TrxName());
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.closeResults(pstmt, rs);
                throw throwable;
            }
            JDBCUtils.closeResults(pstmt, rs);
        }
        return this.m_reportDef;
    }

    @Override
    public void setF3P_ReportDef_ID(int F3P_ReportDef_ID) {
        this.m_reportDef = null;
        super.setF3P_ReportDef_ID(F3P_ReportDef_ID);
    }

    public boolean checkIfApplicable(int WindowNo, int TabNo, Collection<String> lstTag) {
        return this.checkIfApplicable(WindowNo, TabNo, lstTag, false);
    }

    public boolean checkIfApplicable(int WindowNo, int TabNo, Collection<String> lstTag, boolean bTryUppercaseVal) {
        if (lstTag != null && lstTag.size() > 0) {
            Collection<String> tags = MReportInt.splitTag(this.getTag());
            boolean bTagMatch = false;
            for (String sTag : tags) {
                for (String sFilter : lstTag) {
                    if (!sTag.equalsIgnoreCase(sFilter)) continue;
                    bTagMatch = true;
                    break;
                }
                if (bTagMatch) break;
            }
            if (!bTagMatch) {
                return false;
            }
        }
        if (this.getColumnName() != null && this.getColumnValue() != null) {
            String sVal = Env.getContext(this.getCtx(), WindowNo, TabNo, this.getColumnName());
            if (bTryUppercaseVal && (sVal == null || sVal.length() == 0)) {
                sVal = Env.getContext(this.getCtx(), WindowNo, TabNo, this.getColumnName().toUpperCase());
            }
            return sVal.equals(this.getColumnValue());
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getDestFile(int WinNo, int TabNo, String sExt) throws SQLException {
        File fDest = null;
        MReportDef def = this.getDefinition();
        if (def == null) throw new AdempiereException("@F3P_Error_NoReport@");
        File fReport = def.getReportFile();
        if (fReport == null) throw new AdempiereException("@F3P_Error_NoReport@");
        fDest = fReport;
        String sName = this.getAllegato();
        if (Utils.isEmptyString(sName) && Utils.isEmptyString(sName = def.getNome()) && (sName = fReport.getName()).startsWith("f3padsrc_")) {
            sName = sName.substring("f3padsrc_".length());
        }
        sName = Env.parseContext(this.getCtx(), WinNo, TabNo, sName, false, true);
        sName = FileStreamUtils.convertToSafeFilename(sName, '_');
        fDest = new File(fReport.getParent(), sName);
        fDest = FileStreamUtils.setFileExtension(fDest, sExt);
        return MReportDef.getNonExistingFile(fDest, true);
    }
}

