/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.X_F3P_ReportDef;
import com.f3p.adempiere.resource.ResourceLocator;
import com.f3p.commons.Utils;
import java.io.File;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.report.ReportStarter;
import org.compiere.util.Env;

public class MReportDef
extends X_F3P_ReportDef {
    private static final long serialVersionUID = 1L;
    public static final String SUB_PREFIX = "sub_";
    public static final String SRC_PREFIX = "f3padsrc_";
    public static final String REPORT_PREFIX = "@REPORT=";

    public MReportDef(Properties ctx, int F3P_ReportDef_ID, String trxName) {
        super(ctx, F3P_ReportDef_ID, trxName);
    }

    public MReportDef(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isReportFromAttachment() {
        String sNome = this.getDescrizione();
        return Utils.isEmptyString(sNome) || !sNome.startsWith(REPORT_PREFIX);
    }

    public File getReportFile() {
        File fReport = null;
        String sNome = this.getDescrizione();
        if (this.isReportFromAttachment()) {
            MAttachment attachment = this.getAttachment();
            if (attachment != null) {
                int i = 0;
                while (i < attachment.getEntryCount()) {
                    MAttachmentEntry me = attachment.getEntry(i);
                    String sName = me.getName();
                    File fRep = null;
                    fRep = me.getName().startsWith(SUB_PREFIX) ? new File(ResourceLocator.getResourceTempLocation(), sName) : new File(ResourceLocator.getResourceTempLocation(), SRC_PREFIX + sName);
                    fRep = MReportDef.getNonExistingFile(fRep, true);
                    me.getFile(fRep.getAbsoluteFile());
                    if (!me.getName().startsWith(SUB_PREFIX)) {
                        fReport = fRep;
                    }
                    ++i;
                }
            }
        } else {
            String sReportName = sNome.substring(REPORT_PREFIX.length());
            ReportStarter.setReportHome(Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()));
            ReportStarter repoStarter = new ReportStarter();
            fReport = repoStarter.getReportFile(sReportName);
        }
        return fReport;
    }

    public static File getNonExistingFile(File fToCheck, boolean bDelOnExit) {
        int iSeq = 1;
        File fNonExisting = new File(fToCheck.toURI());
        while (fNonExisting.exists()) {
            if (fNonExisting.delete()) continue;
            File fNewBase = new File(fToCheck.getParent(), Integer.toString(iSeq));
            fNewBase.mkdirs();
            fNonExisting = new File(fNewBase, fToCheck.getName());
        }
        if (bDelOnExit) {
            fNonExisting.deleteOnExit();
        }
        return fNonExisting;
    }
}

