/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.util.QueryRepo;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.ListIterator;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_M_InOut;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MMatchPO;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InOutValidator
extends AbstractBoostrappableValidator
implements FactsValidator {
    public static final String PACKAGE = "com/f3p/adempiere/model/";
    public static final String USEORDERINVOICECOST = "F3P_INOUTACCT_COSTFROMINVOICEORDER";

    @Override
    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO model) {
        I_M_InOut mInOut;
        if (model instanceof I_M_InOut && !(mInOut = (I_M_InOut)((Object)model)).isSOTrx() && MSysConfig.getBooleanValue(USEORDERINVOICECOST, false, model.getAD_Client_ID(), model.getAD_Org_ID())) {
            String sSQLInvoice = QueryRepo.getQuery("com/f3p/adempiere/model/inoutacct_invoiceamt", this.getClass().getClassLoader());
            String sSQLOrder = QueryRepo.getQuery("com/f3p/adempiere/model/inoutacct_orderamt", this.getClass().getClassLoader());
            for (Fact fact : facts) {
                FactLine[] factLineArray = fact.getLines();
                int n = factLineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FactLine factLine = factLineArray[n2];
                    int M_InOutLine_ID = factLine.getLine_ID();
                    Amounts amounts = this.getAmounts(sSQLInvoice, mInOut.getDateAcct(), schema.getC_Currency_ID(), M_InOutLine_ID, model.get_TrxName());
                    if (amounts == null) {
                        amounts = this.getAmounts(sSQLOrder, mInOut.getDateAcct(), schema.getC_Currency_ID(), M_InOutLine_ID, model.get_TrxName());
                    }
                    if (amounts != null) {
                        if (factLine.getAmtAcctDr() != null && factLine.getAmtAcctDr().compareTo(Env.ZERO) > 0) {
                            factLine.setAmtSource(factLine.getC_Currency_ID(), amounts.bdAmount, null);
                            factLine.setAmtAcct(factLine.getC_Currency_ID(), amounts.bdConvertedAmount, null);
                        } else {
                            factLine.setAmtSource(factLine.getC_Currency_ID(), null, amounts.bdAmount);
                            factLine.setAmtAcct(factLine.getC_Currency_ID(), null, amounts.bdConvertedAmount);
                        }
                    }
                    ++n2;
                }
            }
        }
        if (model instanceof MMatchPO) {
            MMatchPO mMatch = (MMatchPO)model;
            MProduct product = MProduct.get(mMatch.getCtx(), mMatch.getM_Product_ID());
            if (MSysConfig.getBooleanValue(USEORDERINVOICECOST, false, model.getAD_Client_ID(), model.getAD_Org_ID())) {
                ListIterator<Fact> itFacts = facts.listIterator();
                while (itFacts.hasNext()) {
                    Fact fact;
                    fact = itFacts.next();
                    String costingMethod = product.getCostingMethod(fact.getAcctSchema());
                    if (!"S".equals(costingMethod)) continue;
                    itFacts.remove();
                }
            }
        }
        return null;
    }

    protected Amounts getAmounts(String sSQL, Timestamp tsDate, int C_Currency_ID, int M_InOutLine_ID, String sTrx) {
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
        ResultSet rs = null;
        Amounts retAmounts = null;
        try {
            try {
                pstmt.setInt(1, C_Currency_ID);
                pstmt.setTimestamp(2, tsDate);
                pstmt.setInt(3, M_InOutLine_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retAmounts = new Amounts();
                    retAmounts.bdAmount = rs.getBigDecimal("Amt");
                    retAmounts.bdConvertedAmount = rs.getBigDecimal("ConvertedAmt");
                    if (retAmounts.bdAmount == null || retAmounts.bdConvertedAmount == null) {
                        retAmounts = null;
                    }
                }
            }
            catch (SQLException e) {
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return retAmounts;
    }

    @Override
    public String docValidate(PO model, int timing) {
        return null;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        super.initialize(engine, mClient);
        this.addFactsValidate(engine, "M_InOut");
        this.addFactsValidate(engine, "M_MatchPO");
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        return null;
    }

    protected class Amounts {
        protected BigDecimal bdAmount;
        protected BigDecimal bdConvertedAmount;

        protected Amounts() {
        }
    }
}

