/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.util.ModelFactory;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.X_C_TaxDefinition;

public class GlobalTaxValidator
extends AbstractBoostrappableValidator {
    private static final String TAX_PRODUCT_WHERE = " AND (M_Product_ID = ? OR M_Product_ID IS NULL) AND (M_Product_Category_ID = ? OR M_Product_Category_ID IS NULL) AND (C_TaxCategory_ID = ? OR C_TaxCategory_ID IS NULL)";
    private static final String TAX_CHARGE_WHERE = " AND (C_TaxCategory_ID = ? OR C_TaxCategory_ID IS NULL)";

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        super.initialize(engine, mClient);
        this.addModelChange(engine, "C_Order");
        this.addModelChange(engine, "C_OrderLine");
        this.addModelChange(engine, "C_Invoice");
        this.addModelChange(engine, "C_InvoiceLine");
        this.addDocValidate(engine, "C_Order");
        this.addDocValidate(engine, "C_Invoice");
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String docValidate(PO model, int timing) {
        block2: {
            block3: {
                if (timing != 7 && timing != 1) break block2;
                if (!(model instanceof MInvoice)) break block3;
                MInvoice mInvoice = (MInvoice)model;
                MInvoiceLine[] mInvoiceLineArray = mInvoice.getLines();
                int n = mInvoiceLineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MInvoiceLine invLine = mInvoiceLineArray[n2];
                    this.processInvoice(invLine, mInvoice, model.get_TrxName());
                    invLine.saveEx();
                    ++n2;
                }
                break block2;
            }
            if (!(model instanceof MOrder)) break block2;
            MOrder mOrder = (MOrder)model;
            MOrderLine[] mOrderLineArray = mOrder.getLines();
            int n = mOrderLineArray.length;
            int n3 = 0;
            while (n3 < n) {
                MOrderLine ordLine = mOrderLineArray[n3];
                this.processOrder(ordLine, mOrder, model.get_TrxName());
                ordLine.saveEx();
                ++n3;
            }
        }
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        if (nType == 1 || nType == 2) {
            if (model instanceof MInvoice) {
                MInvoice mInvoice = (MInvoice)model;
                if (mInvoice.is_ValueChanged("C_BPartner_ID") || mInvoice.is_ValueChanged("DateInvoiced")) {
                    MInvoiceLine[] lines;
                    MInvoiceLine[] mInvoiceLineArray = lines = mInvoice.getLines();
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MInvoiceLine mInvLine = mInvoiceLineArray[n2];
                        this.processInvoice(mInvLine, mInvoice, model.get_TrxName());
                        mInvLine.saveEx();
                        ++n2;
                    }
                }
            } else if (model instanceof MInvoiceLine) {
                MInvoiceLine mInvLine = (MInvoiceLine)model;
                this.processInvoice(mInvLine, null, model.get_TrxName());
            } else if (model instanceof MOrder) {
                MOrder mOrder = (MOrder)model;
                if (mOrder.is_ValueChanged("DatePromised")) {
                    MOrderLine[] lines;
                    MOrderLine[] mOrderLineArray = lines = mOrder.getLines();
                    int n = lines.length;
                    int n3 = 0;
                    while (n3 < n) {
                        MOrderLine mOrderLine = mOrderLineArray[n3];
                        this.processOrder(mOrderLine, mOrder, model.get_TrxName());
                        mOrderLine.saveEx();
                        ++n3;
                    }
                }
            } else if (model instanceof MOrderLine) {
                MOrderLine mOrdLine = (MOrderLine)model;
                this.processOrder(mOrdLine, null, model.get_TrxName());
            }
        }
        return null;
    }

    protected void processInvoice(MInvoiceLine mInvLine, MInvoice mInvoice, String sTrxName) {
        if (mInvoice == null) {
            mInvoice = mInvLine.getParent();
        }
        if (mInvLine.getM_Product_ID() <= 0 && mInvLine.getC_Charge_ID() <= 0 || mInvoice.isProcessed()) {
            return;
        }
        if (!(mInvLine.is_new() || mInvLine.is_ValueChanged("M_Product_ID") || mInvLine.is_ValueChanged("C_Charge_ID") || mInvoice.is_ValueChanged("DateInvoiced") || mInvoice.is_ValueChanged("C_BPartner_ID"))) {
            return;
        }
        Properties ctx = mInvLine.getCtx();
        MOrgInfo mOrgInfo = MOrgInfo.get(ctx, mInvLine.getAD_Org_ID(), sTrxName);
        int C_Tax_ID = GlobalTaxValidator.getC_Tax_ID(ctx, mInvoice.getDateInvoiced(), mOrgInfo.getAD_OrgType_ID(), mInvoice.getC_BPartner_ID(), mInvLine.getM_Product_ID(), mInvLine.getC_Charge_ID(), sTrxName);
        if (C_Tax_ID > 0) {
            mInvLine.setC_Tax_ID(C_Tax_ID);
            mInvLine.setTaxAmt();
        }
    }

    protected void processOrder(MOrderLine mOrdLine, MOrder mOrder, String sTrxName) {
        int C_Tax_ID;
        if (mOrder == null) {
            mOrder = mOrdLine.getParent();
        }
        if (mOrdLine.getM_Product_ID() <= 0 && mOrdLine.getC_Charge_ID() <= 0 || mOrder.isProcessed()) {
            return;
        }
        if (!(mOrdLine.is_new() || mOrdLine.is_ValueChanged("M_Product_ID") || mOrdLine.is_ValueChanged("C_Charge_ID") || mOrdLine.is_ValueChanged("C_BPartner_ID") || mOrder.is_ValueChanged("DatePromised"))) {
            return;
        }
        Properties ctx = mOrdLine.getCtx();
        MOrgInfo mOrgInfo = MOrgInfo.get(ctx, mOrdLine.getAD_Org_ID(), sTrxName);
        Timestamp tsDate = mOrdLine.getDatePromised();
        if (tsDate == null) {
            tsDate = mOrdLine.getDateOrdered();
        }
        if ((C_Tax_ID = GlobalTaxValidator.getC_Tax_ID(ctx, tsDate, mOrgInfo.getAD_OrgType_ID(), mOrdLine.getC_BPartner_ID(), mOrdLine.getM_Product_ID(), mOrdLine.getC_Charge_ID(), sTrxName)) > 0) {
            mOrdLine.setC_Tax_ID(C_Tax_ID);
        }
    }

    public static int getC_Tax_ID(Properties ctx, Timestamp tsDate, int AD_OrgType_ID, int C_BPartner_ID, int M_Product_ID, int C_Charge_ID, String sTrxName) {
        MBPartner mBPartner = MBPartner.get(ctx, C_BPartner_ID);
        String sWhereClause = " (AD_OrgType_ID = ? OR AD_OrgType_ID IS NULL) AND (C_TaxGroup_ID = ? OR C_TaxGroup_ID IS NULL) AND (" + DB.TO_DATE(tsDate, true) + " >= ValidFrom OR ValidFrom IS NULL)" + " AND (" + DB.TO_DATE(tsDate, true) + " >= ValidTo OR ValidTo IS NULL)" + " AND (C_BPartner_ID = ? OR C_BPartner_ID IS NULL)" + " AND (C_BP_Group_ID = ? OR C_BP_Group_ID IS NULL)";
        LinkedList<Object> lstParams = new LinkedList<Object>();
        lstParams.add(AD_OrgType_ID);
        lstParams.add(mBPartner.getC_TaxGroup_ID());
        lstParams.add(C_BPartner_ID);
        lstParams.add(mBPartner.getC_BP_Group_ID());
        if (M_Product_ID > 0 && C_Charge_ID > 0) {
            throw new AdempiereException("Only one of M_Product_ID and C_Charge_ID can be specified");
        }
        if (M_Product_ID > 0) {
            MProduct mProduct = ModelFactory.getProduct(ctx, M_Product_ID, sTrxName);
            sWhereClause = String.valueOf(sWhereClause) + TAX_PRODUCT_WHERE;
            lstParams.add(M_Product_ID);
            lstParams.add(mProduct.getM_Product_Category_ID());
            lstParams.add(mProduct.getC_TaxCategory_ID());
        } else if (C_Charge_ID > 0) {
            MCharge mCharge = ModelFactory.getCharge(ctx, C_Charge_ID, sTrxName);
            sWhereClause = String.valueOf(sWhereClause) + TAX_CHARGE_WHERE;
            lstParams.add(mCharge.getC_TaxCategory_ID());
        }
        Query qTax = new Query(ctx, "C_TaxDefinition", sWhereClause, sTrxName);
        X_C_TaxDefinition tDef = (X_C_TaxDefinition)qTax.setApplyAccessFilter(true).setOnlyActiveRecords(true).setOrderBy("SeqNo").setParameters(lstParams).first();
        if (tDef != null) {
            return tDef.getC_Tax_ID();
        }
        return -1;
    }

    public void afterLoadPreferences(Properties ctx) {
        int C_TaxCategory_ID = Env.getContextAsInt(ctx, "#C_TaxCategory_ID");
        if (C_TaxCategory_ID > 0) {
            Query qTax = new Query(ctx, "C_Tax", "C_TaxCategory_ID = ? AND IsDefault='Y'", null);
            qTax.setOnlyActiveRecords(true).setParameters(C_TaxCategory_ID);
            MTax mTax = (MTax)qTax.first();
            if (mTax != null) {
                Env.setContext(ctx, "#C_Tax_ID", mTax.getC_Tax_ID());
            }
        }
    }
}

