/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.model.CommonValidator;
import java.math.BigDecimal;
import org.compiere.model.MInvoiceLine;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Before;
import org.junit.Test;

public class CommonValidatorTest
extends EasyMockSupport {
    private MInvoiceLine m_mLine;
    private CommonValidator m_validator;

    @Before
    public void setUp() {
        this.m_mLine = (MInvoiceLine)this.createNiceMock(MInvoiceLine.class);
        this.m_validator = new CommonValidator();
    }

    @Test
    public void testNoProductOrCharge() {
        EasyMock.expect((Object)this.m_mLine.isDescription()).andReturn((Object)false);
        EasyMock.expect((Object)this.m_mLine.getM_Product_ID()).andReturn((Object)0);
        EasyMock.expect((Object)this.m_mLine.getC_Charge_ID()).andReturn((Object)0);
        EasyMock.expect((Object)this.m_mLine.getLineNetAmt()).andReturn((Object)BigDecimal.ZERO);
        this.m_mLine.setIsDescription(true);
        this.replayAll();
        this.m_validator.setOrResetIsDescription(this.m_mLine);
        this.verifyAll();
    }

    @Test
    public void testResetWithProduct() {
        EasyMock.expect((Object)this.m_mLine.isDescription()).andReturn((Object)true);
        EasyMock.expect((Object)this.m_mLine.getM_Product_ID()).andReturn((Object)1);
        EasyMock.expect((Object)this.m_mLine.getC_Charge_ID()).andReturn((Object)0).anyTimes();
        this.m_mLine.setIsDescription(false);
        this.replayAll();
        this.m_validator.setOrResetIsDescription(this.m_mLine);
        this.verifyAll();
    }

    @Test
    public void testResetWithCharge() {
        EasyMock.expect((Object)this.m_mLine.isDescription()).andReturn((Object)true);
        EasyMock.expect((Object)this.m_mLine.getM_Product_ID()).andReturn((Object)0);
        EasyMock.expect((Object)this.m_mLine.getC_Charge_ID()).andReturn((Object)1);
        this.m_mLine.setIsDescription(false);
        this.replayAll();
        this.m_validator.setOrResetIsDescription(this.m_mLine);
        this.verifyAll();
    }
}

