/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.adempiere.acct.PaymentAndAllocationClearingValidator;
import com.f3p.adempiere.bank.account.model.F3PMBPartner;
import com.f3p.adempiere.bank.account.model.F3PMInvoice;
import com.f3p.adempiere.model.AbstractBootstrapValidator;
import com.f3p.adempiere.model.AccountingSetupValidator;
import com.f3p.adempiere.model.F3PMOrder;
import com.f3p.adempiere.model.GlobalTaxValidator;
import com.f3p.adempiere.model.GuaranteeValidator;
import com.f3p.adempiere.model.InOutValidator;
import com.f3p.adempiere.model.InvoiceValidator;
import com.f3p.adempiere.model.OrderDeleteValidator;
import com.f3p.adempiere.model.RequisitionValidator;
import com.f3p.adempiere.model.TimeExpenseValidator;
import com.f3p.adempiere.rma.RMAValidator;
import java.util.Properties;
import org.compiere.model.GridTable;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_Product;
import org.compiere.util.Env;

public class CommonValidator
extends AbstractBootstrapValidator {
    protected static final String DOC_BASE_TYPE_SOO = "SOO";
    protected static final String MODEL_OVERRIDE_PACKAGE = "com.f3p.adempiere.model.override";

    public CommonValidator() {
        this.addValidator(new RMAValidator());
        this.addValidator(new GlobalTaxValidator());
        this.addValidator(new GuaranteeValidator());
        this.addValidator(new OrderDeleteValidator());
        this.addValidator(new InvoiceValidator());
        this.addValidator(new InOutValidator());
        this.addValidator(new PaymentAndAllocationClearingValidator());
        this.addValidator(new RequisitionValidator());
        this.addValidator(new TimeExpenseValidator());
        this.addValidator(new AccountingSetupValidator());
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        super.initialize(engine, mClient);
        MTable.addCustomPackages(MODEL_OVERRIDE_PACKAGE);
        this.addModelChange(engine, "C_Invoice");
        this.addModelChange(engine, "C_InvoiceLine");
        this.addModelChange(engine, "C_Order");
        this.addModelChange(engine, "C_OrderLine");
        this.addModelChange(engine, "M_Product");
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        if (nType == 2 || nType == 1) {
            if (model instanceof X_C_InvoiceLine) {
                this.setOrResetIsDescription((X_C_InvoiceLine)model);
            } else if (model instanceof X_C_OrderLine) {
                this.setOrResetIsDescription((X_C_OrderLine)model);
            } else if (model instanceof X_C_Order) {
                this.setDocSubType((X_C_Order)model);
            }
            this.setBankAccountID(model, nType);
            if (nType == 1 && model instanceof X_M_Product && GridTable.isSavedFromUI(model)) {
                X_M_Product mProd = (X_M_Product)model;
                mProd.setIsBOM(false);
                mProd.setIsVerified(false);
            }
        }
        return super.modelChange(model, nType);
    }

    protected void setBankAccountID(PO model, int nType) {
        MOrderLine mOrderLine;
        int C_Order_ID;
        int C_OrderLine_ID;
        MInvoice mInvoice;
        X_C_InvoiceLine mInvoiceLine;
        int C_Invoice_ID;
        if (nType == 1 && model instanceof X_C_Order) {
            MBPartner mBP;
            int C_BankAccount_ID;
            int C_BPartner_ID;
            X_C_Order mOrder = (X_C_Order)model;
            if (mOrder.isSOTrx() && F3PMOrder.getC_BankAccount_ID(mOrder) <= 0 && (C_BPartner_ID = mOrder.getC_BPartner_ID()) > 0 && (C_BankAccount_ID = F3PMBPartner.getC_BankAccount_ID(mBP = MBPartner.get(mOrder.getCtx(), C_BPartner_ID)).intValue()) != 0) {
                F3PMOrder.setC_BankAccount_ID(mOrder, C_BankAccount_ID);
            }
        } else if (nType == 1 && model instanceof X_C_Invoice) {
            int C_Order_ID2;
            X_C_Invoice mInvoice2 = (X_C_Invoice)model;
            if (mInvoice2.isSOTrx() && F3PMInvoice.getC_BankAccount_ID(mInvoice2) <= 0 && (C_Order_ID2 = mInvoice2.getC_Order_ID()) > 0) {
                MOrder mOrder = new MOrder(mInvoice2.getCtx(), C_Order_ID2, mInvoice2.get_TrxName());
                F3PMInvoice.setBankAccountFromOrder(mInvoice2, mOrder);
            }
        } else if (nType == 1 && model instanceof X_C_InvoiceLine && (C_Invoice_ID = (mInvoiceLine = (X_C_InvoiceLine)model).getC_Invoice_ID()) > 0 && (mInvoice = new MInvoice(mInvoiceLine.getCtx(), C_Invoice_ID, mInvoiceLine.get_TrxName())).isSOTrx() && F3PMInvoice.getC_BankAccount_ID(mInvoice) <= 0 && (C_OrderLine_ID = mInvoiceLine.getC_OrderLine_ID()) > 0 && (C_Order_ID = (mOrderLine = new MOrderLine(mInvoiceLine.getCtx(), C_OrderLine_ID, mInvoiceLine.get_TrxName())).getC_Order_ID()) > 0) {
            MOrder mOrder = new MOrder(mInvoiceLine.getCtx(), C_Order_ID, mInvoiceLine.get_TrxName());
            F3PMInvoice.setBankAccountFromOrder(mInvoice, mOrder);
            mInvoice.saveEx();
        }
    }

    protected void setOrResetIsDescription(X_C_InvoiceLine mInvoiceLine) {
        if (mInvoiceLine.isDescription()) {
            if (mInvoiceLine.getM_Product_ID() > 0 || mInvoiceLine.getC_Charge_ID() > 0 || mInvoiceLine.getLineNetAmt().signum() != 0) {
                mInvoiceLine.setIsDescription(false);
            }
        } else if (mInvoiceLine.getM_Product_ID() <= 0 && mInvoiceLine.getC_Charge_ID() <= 0 && mInvoiceLine.getLineNetAmt().signum() == 0) {
            mInvoiceLine.setIsDescription(true);
        }
    }

    protected void setOrResetIsDescription(X_C_OrderLine mOrderLine) {
        if (mOrderLine.isDescription()) {
            if (mOrderLine.getM_Product_ID() > 0 || mOrderLine.getC_Charge_ID() > 0 || mOrderLine.getLineNetAmt().signum() != 0) {
                mOrderLine.setIsDescription(false);
            }
        } else if (mOrderLine.getM_Product_ID() <= 0 && mOrderLine.getC_Charge_ID() <= 0 && mOrderLine.getLineNetAmt().signum() == 0) {
            mOrderLine.setIsDescription(true);
        }
    }

    protected void setDocSubType(X_C_Order mOrder) {
        String sSubType;
        int C_DocType_ID = mOrder.getC_DocTypeTarget_ID();
        MDocType docType = new MDocType(Env.getCtx(), C_DocType_ID, null);
        String sBaseType = docType.getDocBaseType();
        if (sBaseType.equals(DOC_BASE_TYPE_SOO) && (sSubType = docType.getDocSubTypeSO()) != null) {
            mOrder.setOrderType(sSubType);
        }
    }

    public void afterLoadPreferences(Properties ctx) {
        int C_TaxCategory_ID = Env.getContextAsInt(ctx, "#C_TaxCategory_ID");
        if (C_TaxCategory_ID > 0) {
            Query qTax = new Query(ctx, "C_Tax", "C_TaxCategory_ID = ? AND IsDefault='Y'", null);
            qTax.setOnlyActiveRecords(true).setParameters(C_TaxCategory_ID);
            MTax mTax = (MTax)qTax.first();
            if (mTax != null) {
                Env.setContext(ctx, "#C_Tax_ID", mTax.getC_Tax_ID());
            }
        }
    }
}

