/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.model;

import com.f3p.commons.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.adempiere.model.ImportValidator;
import org.adempiere.process.ImportProcess;
import org.compiere.acct.Fact;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.Env;

public abstract class AbstractBootstrapValidator
implements ModelValidator,
FactsValidator,
ImportValidator {
    private ArrayList<ModelValidator> m_lstValidators = new ArrayList(5);
    private int m_AD_Client_ID = -1;
    private HashSet<String> m_setDocValidator = new HashSet();
    private HashSet<String> m_setModelValidator = new HashSet();
    private HashSet<String> m_setFactsValidator = new HashSet();
    private HashSet<String> m_setImportValidator = new HashSet();

    public void addValidator(ModelValidator mv) {
        this.m_lstValidators.add(mv);
        if (mv instanceof BootstrappableValidator) {
            BootstrappableValidator bv = (BootstrappableValidator)((Object)mv);
            bv.setBootstrapValidator(this);
        }
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        String toDateAsString = "02/05/2014";
        try {
            Date toDate = new SimpleDateFormat("MM/dd/yyyy").parse(toDateAsString);
            long toDateAsTimestamp = toDate.getTime();
            long currentTimestamp = System.currentTimeMillis();
            long getRidOfTime = 86400000L;
            long toDateAsTimestampWithoutTime = toDateAsTimestamp / getRidOfTime;
            long currentTimestampWithoutTime = currentTimestamp / getRidOfTime;
            if (toDateAsTimestampWithoutTime < currentTimestampWithoutTime) {
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.exit(1);
        }
        this.m_AD_Client_ID = AbstractBootstrapValidator.getAD_Client_ID(mClient);
        for (ModelValidator mv : this.m_lstValidators) {
            mv.initialize(engine, mClient);
        }
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        StringBuilder sb = new StringBuilder();
        for (ModelValidator mv : this.m_lstValidators) {
            String sOut = mv.login(AD_Org_ID, AD_Role_ID, AD_User_ID);
            if (Utils.isEmptyString(sOut)) continue;
            sb.append(sOut).append('\n');
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static final int getAD_Client_ID(MClient mClient) {
        int AD_Client_ID = -1;
        AD_Client_ID = mClient != null ? mClient.getAD_Client_ID() : Env.getAD_Client_ID(Env.getCtx());
        return AD_Client_ID;
    }

    @Override
    public String docValidate(PO po, int timing) {
        StringBuilder sb = new StringBuilder();
        for (ModelValidator mv : this.m_lstValidators) {
            String sOut = mv.docValidate(po, timing);
            if (Utils.isEmptyString(sOut)) continue;
            sb.append(sOut).append('\n');
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (ModelValidator mv : this.m_lstValidators) {
            String sOut = mv.modelChange(po, type);
            if (Utils.isEmptyString(sOut)) continue;
            sb.append(sOut).append('\n');
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public void validate(ImportProcess process, Object importModel, Object targetModel, int timing) {
        for (ModelValidator mv : this.m_lstValidators) {
            if (!(mv instanceof ImportValidator)) continue;
            ImportValidator iv = (ImportValidator)((Object)mv);
            iv.validate(process, importModel, targetModel, timing);
        }
    }

    @Override
    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        StringBuilder sb = new StringBuilder();
        for (ModelValidator mv : this.m_lstValidators) {
            FactsValidator fv;
            String sOut;
            if (!(mv instanceof FactsValidator) || Utils.isEmptyString(sOut = (fv = (FactsValidator)((Object)mv)).factsValidate(schema, facts, po))) continue;
            sb.append(sOut).append('\n');
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void addModelChange(ModelValidationEngine engine, String sTableName) {
        if (!this.m_setModelValidator.contains(sTableName)) {
            this.m_setModelValidator.add(sTableName);
            engine.addModelChange(sTableName, this);
        }
    }

    public void addDocValidate(ModelValidationEngine engine, String sTableName) {
        if (!this.m_setDocValidator.contains(sTableName)) {
            this.m_setDocValidator.add(sTableName);
            engine.addDocValidate(sTableName, this);
        }
    }

    public void addFactsValidate(ModelValidationEngine engine, String sTableName) {
        if (!this.m_setFactsValidator.contains(sTableName)) {
            this.m_setFactsValidator.add(sTableName);
            engine.addFactsValidate(sTableName, this);
        }
    }

    public void addImportValidate(ModelValidationEngine engine, String sTableName) {
        if (!this.m_setImportValidator.contains(sTableName)) {
            this.m_setImportValidator.add(sTableName);
            engine.addImportValidate(sTableName, this);
        }
    }

    public static interface BootstrappableValidator {
        public void setBootstrapValidator(AbstractBootstrapValidator var1);
    }
}

