/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.mail.zimbra;

import com.f3p.zimbra.ZimbraAccountInfo;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.zclient.ZSignature;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.Env;

public class ZimbraDraftBuilder {
    protected static final String ZCLIENT_BASE_URL = "ZCLIENT_BASE_URL";
    protected static final String ZCLIENT_ADD_SIGNATURE = "ZCLIENT_ADD_SIGNATURE";
    protected static final String ZCLIENT_OPENZIMBRAUI = "ZCLIENT_OPEN_ZIMBRAUI";
    protected static final String ZCLIENT_FORCEHTML = "ZCLIENT_FORCE_HTML";
    protected static final String MSG_SUCCESS = "F3P_MSG_ZimbraDraftCreationSuccesful";

    public String buildDraftMail(MUser mCurrentUser, MUser mfrom, String sTo, String sSubject, String sContent, File[] fAttachments, List<String> lstTags, boolean bHtml) {
        String sDBID = null;
        String sEmail = mCurrentUser.getEMailUser();
        String sPassword = mCurrentUser.getEMailUserPW();
        ZimbraAccountInfo accountInfo = null;
        try {
            accountInfo = new ZimbraAccountInfo(sEmail, sPassword, MSysConfig.getValue(ZCLIENT_BASE_URL, Env.getAD_Client_ID(mCurrentUser.getCtx()), Env.getAD_Org_ID(mCurrentUser.getCtx())), null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        try {
            MimeMessage msg = this.createMessage(mCurrentUser, mfrom.getEMail(), sTo, sSubject, sContent, fAttachments, bHtml, accountInfo);
            ParsedMessage pm = new ParsedMessage(msg, 0L, false);
            String sTags = null;
            if (lstTags != null && lstTags.size() != 0) {
                sTags = accountInfo.getTags(lstTags);
            }
            sDBID = accountInfo.addMessage(msg, "6", "ds", sTags, 0L, pm.getRawData());
        }
        catch (Exception e) {
            throw new AdempiereException("Zimbra Connection Error:", e);
        }
        return sDBID;
    }

    public URL getDraftEditUrl(String sDBID, Properties ctx) {
        URL url = null;
        String sBaseUrl = MSysConfig.getValue(ZCLIENT_BASE_URL, Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx));
        if (!sBaseUrl.endsWith("/")) {
            sBaseUrl = String.valueOf(sBaseUrl) + "/";
        }
        String sURI = String.valueOf(sBaseUrl) + "zimbra?draftedit=" + sDBID;
        try {
            url = new URL(sURI);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return url;
    }

    protected MimeMessage createMessage(MUser mCurrentUser, String sFrom, String sTo, String sSubject, String sContent, File[] fAttachments, boolean bHtml, ZimbraAccountInfo zAccountInfo) throws Exception {
        String sSignature;
        MClient mclient = MClient.get(mCurrentUser.getCtx(), mCurrentUser.getAD_Client_ID());
        MimeMessage message = new MimeMessage(null);
        if (sFrom != null && sFrom.trim().length() != 0) {
            message.setFrom((Address)new InternetAddress(sFrom));
        }
        if (sTo != null && sTo.trim().length() != 0) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(sTo));
        }
        if (sSubject != null && sSubject.trim().length() != 0) {
            message.setSubject(sSubject);
        }
        boolean bAddSignature = MSysConfig.getBooleanValue(ZCLIENT_ADD_SIGNATURE, false, Env.getAD_Client_ID(mCurrentUser.getCtx()), Env.getAD_Org_ID(mCurrentUser.getCtx()));
        boolean bForceHTML = MSysConfig.getBooleanValue(ZCLIENT_FORCEHTML, false, Env.getAD_Client_ID(mCurrentUser.getCtx()), Env.getAD_Org_ID(mCurrentUser.getCtx()));
        if (!bHtml && bForceHTML) {
            bHtml = true;
            sContent = ZimbraDraftBuilder.stringToHTMLString(sContent);
        }
        if (bAddSignature && (sSignature = this.getSignature(zAccountInfo, bHtml)) != null && sSignature.length() > 0) {
            StringBuilder content = new StringBuilder(sContent);
            if (content.length() > 0) {
                content.append(this.getSignatureSeparator(bHtml));
            }
            content.append(sSignature);
            sContent = content.toString();
        }
        MimeBodyPart mbp1 = new MimeBodyPart();
        if (bHtml) {
            String sHtmlWrappedContent = "<html><body>" + sContent + "</body></html>";
            mbp1.setContent((Object)sHtmlWrappedContent, "text/html");
        } else {
            mbp1.setContent((Object)sContent, "text/plain");
        }
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        if (fAttachments != null && fAttachments.length != 0) {
            File[] fileArray = fAttachments;
            int n = fAttachments.length;
            int n2 = 0;
            while (n2 < n) {
                File fAttach = fileArray[n2];
                if (fAttach != null) {
                    MimeBodyPart mbp = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(fAttach);
                    mbp.setDataHandler(new DataHandler(fds));
                    mbp.setFileName(fds.getName());
                    mp.addBodyPart((BodyPart)mbp);
                }
                ++n2;
            }
        }
        message.setContent((Multipart)mp);
        return message;
    }

    protected String getSignature(ZimbraAccountInfo zInfo, boolean bHtml) throws Exception {
        ZSignature zSig = zInfo.getSignature(!bHtml, false);
        if (zSig != null) {
            String sSignature = zSig.getValue();
            if (zSig.getType().equals("text/plain") && bHtml) {
                sSignature = ZimbraDraftBuilder.stringToHTMLString(sSignature);
            }
            return sSignature;
        }
        return null;
    }

    protected String getSignatureSeparator(boolean bHtml) {
        if (bHtml) {
            return "<br><br>";
        }
        return "\n\n";
    }

    public static String stringToHTMLString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("&quot;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '\n') {
                    sb.append("<br/>");
                } else {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(new Integer(ci).toString());
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

