/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.mail;

import com.f3p.adempiere.mail.OutboundMailClient;
import java.io.File;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MUser;
import org.compiere.util.Env;

public class OutboundMailClientEngine {
    public static final String COLUMNAME_OUTBOUNDMAILCLIENT = "OutboundEmailClient";
    public static final String DEFAULT_MAIL_CLIENT = "com.f3p.adempiere.mail.StandardOutboundClient";
    private static OutboundMailClientEngine s_engine = null;

    public static OutboundMailClientEngine get() {
        if (s_engine == null) {
            s_engine = new OutboundMailClientEngine();
        }
        return s_engine;
    }

    public OutboundMailClient getOutboundMailClient(MUser user) throws AdempiereException {
        String sClient = this.getClientClassName(user);
        OutboundMailClient omClient = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(sClient);
            omClient = (OutboundMailClient)clazz.newInstance();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return omClient;
    }

    public String getClientClassName(MUser user) {
        String sClassName = user.get_ValueAsString(COLUMNAME_OUTBOUNDMAILCLIENT);
        if (sClassName == null || sClassName.length() == 0) {
            sClassName = DEFAULT_MAIL_CLIENT;
        }
        return sClassName;
    }

    public void sendMail(Object owner, String sUITitle, MUser from, String sTo, String sSubject, String sContent, File[] fAttachments, int WindowNo, int TabNo, OutboundMailClient.ClientType clientType) throws AdempiereException {
        this.sendMail(owner, sUITitle, from, sTo, sSubject, sContent, false, fAttachments, WindowNo, TabNo, clientType);
    }

    public void sendMail(Object owner, String sUITitle, MUser from, String sTo, String sSubject, String sContent, boolean bIsMessageHTML, File[] fAttachments, int WindowNo, int TabNo, OutboundMailClient.ClientType clientType) throws AdempiereException {
        MUser mCurrentUser = MUser.get(Env.getCtx());
        OutboundMailClient omClient = this.getOutboundMailClient(mCurrentUser);
        omClient.sendMail(owner, sUITitle, from, sTo, sSubject, sContent, bIsMessageHTML, fAttachments, WindowNo, TabNo, mCurrentUser, clientType);
    }

    public void sendMail(Object owner, String sUITitle, MUser from, String sTo, String sSubject, String sContent, File fAttachment, int WindowNo, int TabNo, OutboundMailClient.ClientType clientType) throws AdempiereException {
        File[] fAttachments = null;
        if (fAttachment != null) {
            fAttachments = new File[]{fAttachment};
        }
        this.sendMail(owner, sUITitle, from, sTo, sSubject, sContent, fAttachments, WindowNo, TabNo, clientType);
    }
}

