/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.mail;

import com.f3p.adempiere.file.FileBuilder;
import com.f3p.adempiere.mail.MailBuilder;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.model.MReportInt;
import com.f3p.adempiere.report.ReportProcess;
import com.f3p.adempiere.util.EnvHelper;
import com.f3p.commons.FileStreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MMailText;
import org.compiere.model.MUser;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MailProcess
extends ReportProcess {
    private static CLogger s_log = CLogger.getCLogger(MailProcess.class);
    protected MReportDet[] m_detMailBody = null;
    protected boolean m_bAutoSend = false;
    protected FileBuilder m_fileBuilder = null;
    protected String m_sLastMailRecipients = null;
    protected MailBuilder.Outcome m_lastOutcome;
    protected int m_nMailTemplateId;

    public boolean sendMail(int C_BPartner_ID, int AD_User_ID, int nMailTemplateId) throws Exception {
        this.m_nMailTemplateId = nMailTemplateId;
        return this.sendMail(C_BPartner_ID, AD_User_ID);
    }

    public boolean sendMail(int C_BPartner_ID, int AD_User_ID) throws Exception {
        MailBuilder mail = this.getMailBuilder();
        boolean bSuccess = false;
        MReportDet[] mReportDetArray = this.m_rdetail;
        int n = this.m_rdetail.length;
        int n2 = 0;
        while (n2 < n) {
            MReportDet att = mReportDetArray[n2];
            File fAtt = this.m_fileBuilder.getAsPDF(att, this.getCtx(), this.getWindowNo(), this.getTabNo());
            if (fAtt != null) {
                mail.addAttachment(fAtt);
            }
            ++n2;
        }
        if (this.m_nMailTemplateId > 0) {
            MMailText mText = null;
            int C_Invoice_ID = this.getRecord_ID();
            MInvoice modelInvoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
            String sDocumentNo = modelInvoice.getDocumentNo();
            MClient client = MClient.get(this.getCtx());
            MUser to = new MUser(this.getCtx(), AD_User_ID, this.get_TrxName());
            String documentDir = client.getDocumentDir();
            if (documentDir == null || documentDir.length() == 0) {
                documentDir = ".";
            }
            if ((mText = new MMailText(this.getCtx(), this.m_nMailTemplateId, this.get_TrxName())).get_ID() != this.m_nMailTemplateId) {
                throw new AdempiereUserError("@NotFound@: @R_MailText_ID@ - " + this.m_nMailTemplateId);
            }
            String subject = String.valueOf(mText.getMailHeader()) + " - " + sDocumentNo;
            mText.setUser(to);
            mText.setBPartner(C_BPartner_ID);
            mText.setPO(new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName()));
            String message = mText.getMailText(true);
            mail.setSubject(subject);
            mail.setContent(message, mText.isHtml());
            mail.setTo(to.getEMail());
        } else if (this.m_detMailBody != null && this.m_detMailBody.length > 0) {
            String sBody = this.m_detMailBody[0].getCorpo();
            if (sBody != null && sBody.length() > 0) {
                sBody = sBody.replaceAll("\n", "<br>");
                sBody = EnvHelper.parseStringWithEnv(this.getCtx(), sBody, this.getWindowNo(), this.getTabNo());
            } else {
                File fHtml = this.m_fileBuilder.getAsHTML(this.m_detMailBody[0], this.getCtx(), this.getWindowNo(), this.getTabNo());
                if (fHtml != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    FileInputStream fis = new FileInputStream(fHtml);
                    FileStreamUtils.transferStream(fis, bos);
                    fis.close();
                    fHtml.delete();
                    sBody = bos.toString("UTF-8");
                }
            }
            mail.setContent(sBody, true);
            String sSubject = EnvHelper.parseStringWithEnv(this.getCtx(), this.m_detMailBody[0].getOggetto(), this.getWindowNo(), this.getTabNo());
            if (sSubject != null && sSubject.length() > 0) {
                sBody = EnvHelper.parseStringWithEnv(this.getCtx(), sSubject, this.getWindowNo(), this.getTabNo());
            }
            mail.setSubject(sSubject);
            mail.setReadConfirmation(this.m_detMailBody[0].isConferma());
        }
        if (this.reviewMail(mail, C_BPartner_ID, AD_User_ID)) {
            if (!mail.sendMail()) {
                this.addLog(this.getRecord_ID(), new Timestamp(System.currentTimeMillis()), null, String.valueOf(Msg.getMsg(Env.getCtx(), "C3_Error_InioMail")) + mail.getTo());
            } else {
                bSuccess = true;
            }
        }
        this.m_lastOutcome = mail.getOutcome();
        this.m_sLastMailRecipients = String.valueOf(mail.getTo()) + " / " + mail.getCc();
        return bSuccess;
    }

    @Override
    protected String doIt() throws Exception {
        String sRet = "";
        try {
            this.sendMail(0, 0);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "MailProcess.doIt", e);
            sRet = e.getLocalizedMessage();
        }
        return sRet;
    }

    public MailBuilder getMailBuilder() {
        return new MailBuilder(this.getCtx(), this.get_TrxName());
    }

    public Collection<Integer> batchSendMail(Collection<BatchMailEntry> entries) {
        int RecordID = this.getProcessInfo().getRecord_ID();
        String sOkMsg = Msg.getMsg(Env.getCtx(), "C3_Info_InviataMail");
        String sErrMsg = Msg.getMsg(Env.getCtx(), "C3_Error_InvioMail");
        ArrayList<Integer> arSent = new ArrayList<Integer>();
        for (BatchMailEntry bme : entries) {
            int ID2 = bme.getRecord_ID();
            this.getProcessInfo().setRecord_ID(ID2);
            try {
                this.sendMail(bme.getC_BPartner_ID(), bme.getAD_User_ID());
                this.addLog(ID2, new Timestamp(System.currentTimeMillis()), null, String.valueOf(sOkMsg) + " " + this.m_sLastMailRecipients);
                if (!this.m_lastOutcome.equals((Object)MailBuilder.Outcome.SENT)) continue;
                arSent.add(ID2);
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "MailProcess.doIt [" + ID2 + "]", e);
                this.addLog(ID2, new Timestamp(System.currentTimeMillis()), null, String.valueOf(sErrMsg) + " " + this.m_sLastMailRecipients);
            }
        }
        this.getProcessInfo().setRecord_ID(RecordID);
        return arSent;
    }

    public void setAutoSend(boolean bAuto) {
        this.m_bAutoSend = bAuto;
    }

    public boolean isAutoSend() {
        return this.m_bAutoSend;
    }

    public String getAddressFromUser(int AD_User_ID) {
        return DB.getSQLValueString(null, "SELECT EMAIL FROM AD_USER WHERE AD_USER_ID = ?", AD_User_ID);
    }

    public boolean reviewMail(MailBuilder mail, int C_BPartner_ID, int AD_User_ID_Dest) {
        boolean bRet = true;
        if (AD_User_ID_Dest < 1) {
            AD_User_ID_Dest = Env.getContextAsInt(this.getCtx(), this.getWindowNo(), this.getTabNo(), "AD_User_ID");
        }
        if (C_BPartner_ID < 1) {
            C_BPartner_ID = Env.getContextAsInt(this.getCtx(), this.getWindowNo(), this.getTabNo(), "C_BPartner_ID");
        }
        if (AD_User_ID_Dest > 0) {
            mail.setTo(this.getAddressFromUser(AD_User_ID_Dest));
        } else {
            bRet = !this.isAutoSend();
        }
        return bRet;
    }

    @Override
    public void prepare() {
        this.m_fileBuilder = new FileBuilder(this);
        MReportInt rint = this.getReportInt();
        this.getStdParams();
        if (rint != null) {
            this.m_rdetail = rint.getDetails("A", this.getWindowNo(), this.getTabNo(), this.getTagFilter(), false);
            this.m_detMailBody = rint.getDetails("C", this.getWindowNo(), this.getTabNo(), this.getTagFilter(), false);
        }
    }

    public class BatchMailEntry {
        private int AD_User_ID = 0;
        private int C_BPartner_ID = 0;
        private int Record_ID = 0;

        public BatchMailEntry(int AD_User_ID, int C_BPartner_ID, int Record_ID) {
            this.AD_User_ID = AD_User_ID;
            this.C_BPartner_ID = C_BPartner_ID;
            this.Record_ID = Record_ID;
        }

        public int getAD_User_ID() {
            return this.AD_User_ID;
        }

        public void setAD_User_ID(int user_ID) {
            this.AD_User_ID = user_ID;
        }

        public int getC_BPartner_ID() {
            return this.C_BPartner_ID;
        }

        public void setC_BPartner_ID(int partner_ID) {
            this.C_BPartner_ID = partner_ID;
        }

        public int getRecord_ID() {
            return this.Record_ID;
        }

        public void setRecord_ID(int record_ID) {
            this.Record_ID = record_ID;
        }
    }
}

