/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.mail;

import com.f3p.adempiere.mail.ICalAttachment;
import java.io.File;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.mail.MessagingException;
import org.compiere.model.MClient;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;

public class MailBuilder {
    public static final String ADDRESS_SEP = ",;";
    private static CLogger s_log = CLogger.getCLogger(MailBuilder.class);
    private ArrayList<File> m_arAttachments = new ArrayList();
    private ArrayList<ICalAttachment> m_arICalAttachments = new ArrayList();
    protected Outcome m_outcome = Outcome.NOTSENT;
    protected Properties m_ctx;
    protected MClient m_client;
    protected MUser m_user;
    protected String m_sTrx;
    protected String m_sFrom = null;
    protected String m_sTo = null;
    protected String m_sBcc = "";
    protected String m_sCc = "";
    protected String m_sSubject = null;
    protected String m_sMailBody;
    protected boolean m_bReadConfirmation = false;
    protected boolean m_bIsHTML = false;

    public MailBuilder(Properties ctx, String sTrx) {
        this.m_ctx = ctx;
        this.m_user = MUser.get(this.m_ctx, Env.getAD_User_ID(this.m_ctx));
        this.m_client = MClient.get(Env.getCtx(), Env.getAD_Client_ID(Env.getCtx()));
        this.setFrom(this.m_user.getEMail());
        this.setBCc(this.m_user.getEMail());
    }

    public void setFrom(String sFrom) {
        this.m_sFrom = sFrom;
    }

    public void setBCc(String sBcc) {
        this.m_sBcc = sBcc;
    }

    public void setTo(String sTo) {
        this.m_sTo = sTo;
    }

    public void setSubject(String sSubject) {
        this.m_sSubject = sSubject;
    }

    public void setContent(String sText, boolean bHtml) {
        this.m_sMailBody = sText;
        this.m_bIsHTML = bHtml;
    }

    public String getFrom() {
        return this.m_sFrom;
    }

    public String getTo() {
        return this.m_sTo;
    }

    public String getCc() {
        return this.m_sCc;
    }

    public String getBcc() {
        return this.m_sBcc;
    }

    public String getSubject() {
        return this.m_sSubject;
    }

    public String getContent() {
        return this.m_sMailBody;
    }

    public boolean isContentHtml() {
        return this.m_bIsHTML;
    }

    public boolean isReadConfirmation() {
        return this.m_bReadConfirmation;
    }

    public void addAttachment(File file) {
        if (file.exists()) {
            this.m_arAttachments.add(file);
        }
    }

    public void addICalAttachment(Timestamp tsStart, Timestamp tsEnd, String sSummary) {
        try {
            ICalAttachment attach = new ICalAttachment();
            attach.addEvent(tsStart, tsEnd, sSummary, new URI("MAILTO:" + this.m_user.getEMail()), null);
            this.m_arICalAttachments.add(attach);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "MailBuilder.addICalAttachment", e);
        }
    }

    public void setReadConfirmation(boolean bSend) {
        this.m_bReadConfirmation = bSend;
    }

    public Outcome getOutcome() {
        return this.m_outcome;
    }

    public boolean sendMail() {
        boolean bRes = true;
        StringTokenizer st = new StringTokenizer(this.m_sTo, ADDRESS_SEP);
        if (st.hasMoreTokens()) {
            EMail email = this.m_client.createEMail(st.nextToken(), this.getSubject(), "");
            while (st.hasMoreTokens()) {
                email.addTo(st.nextToken());
            }
            email.setFrom(this.getFrom());
            if (this.m_arICalAttachments.size() == 0) {
                if (this.isContentHtml()) {
                    email.setMessageHTML(this.getContent());
                } else {
                    email.setMessageText(this.getContent());
                }
            } else {
                email.setMessageText("");
            }
            if (this.m_sCc != null) {
                st = new StringTokenizer(this.m_sCc, ADDRESS_SEP);
                while (st.hasMoreTokens()) {
                    email.addCc(st.nextToken());
                }
            }
            if (this.m_sBcc != null) {
                st = new StringTokenizer(this.m_sBcc, ADDRESS_SEP);
                while (st.hasMoreTokens()) {
                    email.addBcc(st.nextToken());
                }
            }
            try {
                for (ICalAttachment ic : this.m_arICalAttachments) {
                    if (this.isContentHtml()) {
                        ic.setTextContent(this.getContent(), "html");
                    } else {
                        ic.setTextContent(this.getContent(), "plain");
                    }
                    ic.finalize();
                    email.addAttachment((Object)ic);
                }
            }
            catch (MessagingException e) {
                bRes = false;
                s_log.log(Level.SEVERE, "MailDialog.sendMail", e);
            }
            for (File fAttachment : this.m_arAttachments) {
                email.addAttachment(fAttachment);
            }
            if (this.isReadConfirmation()) {
                email.setHeader("Disposition-Notification-To", this.m_user.getEMail());
            }
            if (bRes) {
                String sStatus = email.send();
                if (!email.isSentOK()) {
                    bRes = false;
                    this.m_outcome = Outcome.ERRORS;
                } else {
                    MUserMail log = new MUserMail(this.m_ctx, 0, this.m_sTrx);
                    String sBody = this.getContent();
                    if (sBody.length() > 2000) {
                        sBody = sBody.substring(0, 2000);
                    }
                    log.setSubject(this.getSubject());
                    log.setMailText(sBody);
                    log.setAD_User_ID(this.m_user.getAD_User_ID());
                    log.setIsDelivered("Y");
                    String sDeliveryConfirmation = this.isReadConfirmation() ? "Y" : "N";
                    log.setDeliveryConfirmation(sDeliveryConfirmation);
                    if (!log.save()) {
                        s_log.log(Level.SEVERE, "MailDialog.sendMail: impossibile creare log");
                    }
                    this.m_outcome = Outcome.SENT;
                }
            } else {
                this.m_outcome = Outcome.ERRORS;
            }
        } else {
            this.m_outcome = Outcome.NOTORECIPIENT;
            bRes = false;
        }
        return bRes;
    }

    public static enum Outcome {
        SENT,
        NOTSENT,
        ERRORS,
        NOTORECIPIENT;

    }
}

