/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.mail;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Timestamp;
import java.text.DateFormat;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.CompatibilityHints;

public class ICalAttachment
extends MimeMultipart {
    private Calendar m_calRoot = new Calendar();
    private StringBuffer m_sbTextContent = new StringBuffer();
    private DateFormat m_fmtDate = DateFormat.getDateInstance(2);
    private DateFormat m_fmtTime = DateFormat.getTimeInstance(3);
    private TimeZone m_timeZone;
    private VTimeZone m_vTimeZone;
    private int m_iSequence = 0;

    public ICalAttachment() {
        super("alternative");
        PropertyList props = this.m_calRoot.getProperties();
        props.add((Property)new ProdId("FreePath iCal Gen"));
        props.add((Property)Version.VERSION_2_0);
        props.add((Property)CalScale.GREGORIAN);
        props.add((Property)Method.REQUEST);
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        this.m_timeZone = registry.getTimeZone(java.util.TimeZone.getDefault().getID());
        this.m_vTimeZone = this.m_timeZone.getVTimeZone();
        this.m_calRoot.getComponents().add((Component)this.m_vTimeZone);
    }

    public void addEvent(Timestamp tsStart, Timestamp tsEnd, String sSummary, URI uriOrganizer, URI uriAttendee) {
        DateTime dtStart = new DateTime(tsStart.getTime());
        DateTime dtEnd = new DateTime(tsEnd.getTime());
        VEvent event = new VEvent((Date)dtStart, (Date)dtEnd, sSummary);
        PropertyList eventProps = event.getProperties();
        String sUID = String.valueOf(Long.toString(System.currentTimeMillis())) + "@freepath.it";
        TzId tz = new TzId(this.m_vTimeZone.getProperty("TZID").getValue());
        eventProps.add((Property)new Organizer(uriOrganizer));
        eventProps.add((Property)new Uid(sUID));
        eventProps.add((Property)Transp.OPAQUE);
        eventProps.add((Property)new Sequence(this.m_iSequence++));
        eventProps.add((Property)new Description(sSummary));
        if (uriAttendee != null) {
            Attendee attendee = new Attendee(uriAttendee);
            ParameterList attPList = attendee.getParameters();
            attPList.add((Parameter)Role.REQ_PARTICIPANT);
            attPList.add((Parameter)PartStat.NEEDS_ACTION);
            attPList.add((Parameter)Rsvp.TRUE);
            eventProps.add((Property)attendee);
        }
        ParameterList plDtStart = eventProps.getProperty("DTSTART").getParameters();
        plDtStart.add((Parameter)Value.DATE_TIME);
        plDtStart.add((Parameter)tz);
        ParameterList plDtEnd = eventProps.getProperty("DTEND").getParameters();
        plDtEnd.add((Parameter)Value.DATE_TIME);
        plDtEnd.add((Parameter)tz);
        this.m_calRoot.getComponents().add((Component)event);
        this.m_sbTextContent.append("\n");
        this.m_sbTextContent.append(sSummary).append("\n");
        this.m_sbTextContent.append(this.m_fmtDate.format(tsStart)).append("  ");
        this.m_sbTextContent.append(this.m_fmtTime.format(tsStart)).append(" - ").append(this.m_fmtTime.format(tsEnd));
        this.m_sbTextContent.append("\n");
    }

    public void setTextContent(String sContent, String sMimeSubType) {
        this.m_sbTextContent = new StringBuffer(sContent);
    }

    public void finalize() throws MessagingException {
        MimeBodyPart text = new MimeBodyPart();
        text.setText(this.m_sbTextContent.toString(), "UTF-8", "html");
        this.addBodyPart((BodyPart)text);
        MimeBodyPart ics = new MimeBodyPart();
        StringWriter writer = new StringWriter();
        CalendarOutputter out = new CalendarOutputter();
        try {
            CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
            out.output(this.m_calRoot, (Writer)writer);
        }
        catch (Exception e) {
            throw new MessagingException("ICSAttachment.writoTo", e);
        }
        ics.setText(writer.toString(), "UTF-8");
        ics.setHeader("Content-Type", "text/calendar; method=REQUEST; charset=UTF-8");
        this.addBodyPart((BodyPart)ics);
    }
}

