/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.invoiceadv.model;

import com.f3p.adempiere.invoiceadv.model.IADVMBankAccount;
import com.f3p.adempiere.invoiceadv.model.IADVMInvoice;
import com.f3p.adempiere.invoiceadv.model.IADVMInvoiceLine;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.adempiere.util.SequenceHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MLITAdvInvPara;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_C_Payment;
import org.compiere.model.X_LIT_AdvInvPara;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InvoiceAdvanceValidator
implements ModelValidator {
    private static final String SQL_INVADVPERCVALUE = "com/f3p/adempiere/invoiceadv/model/get_invadvpercvalue";
    private static CLogger s_log = CLogger.getCLogger(InvoiceAdvanceValidator.class);
    private int m_AD_Client_ID = -1;
    public static final String ENV_LITADVINVDOCTYPE = "#LIT_AdvInvDocType_ID";

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            s_log.info(client.toString());
        } else {
            s_log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", this);
        engine.addModelChange("C_Payment", this);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("LIT_AdvInvPara", this);
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        s_log.info("AD_User_ID=" + AD_User_ID);
        MOrg mOrg = MOrg.get(Env.getCtx(), AD_Org_ID);
        MLITAdvInvPara mPara = MLITAdvInvPara.get(mOrg.getCtx(), mOrg.getAD_Client_ID());
        if (mPara != null) {
            Env.setContext(mOrg.getCtx(), ENV_LITADVINVDOCTYPE, mPara.getC_DocAdvInv_ID());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String modelChange(PO po, int type) throws Exception {
        MLITAdvInvPara mPara;
        X_C_Invoice mInvoice;
        if (po instanceof X_LIT_AdvInvPara && (type == 5 || type == 4)) {
            X_LIT_AdvInvPara mInvPara = (X_LIT_AdvInvPara)po;
            Env.setContext(mInvPara.getCtx(), ENV_LITADVINVDOCTYPE, mInvPara.getC_DocAdvInv_ID());
        }
        if (po instanceof X_C_Payment && (type == 1 || type == 2)) {
            X_C_Payment mPayment = (X_C_Payment)po;
            String sSQL = QueryRepo.getQuery(SQL_INVADVPERCVALUE, this.getClass().getClassLoader());
            CPreparedStatement pstmt = DB.prepareStatement(sSQL, po.get_TrxName());
            ResultSet rs = null;
            BigDecimal bdLineNetAmt = null;
            boolean bIsPayOnAdvAcc = false;
            int LIT_BankAccAdv_ID = -1;
            try {
                pstmt.setInt(1, mPayment.getC_Invoice_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    bdLineNetAmt = rs.getBigDecimal("LineNetAmt");
                    String sIsPayOnAdvAcc = rs.getString("LIT_IsPayOnAdvAcc");
                    if (sIsPayOnAdvAcc != null && sIsPayOnAdvAcc.equals("Y")) {
                        bIsPayOnAdvAcc = true;
                    }
                    LIT_BankAccAdv_ID = rs.getInt("LIT_BankAccAdv_ID");
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
            if (bdLineNetAmt != null) {
                if (bIsPayOnAdvAcc) {
                    mPayment.setC_BankAccount_ID(LIT_BankAccAdv_ID);
                } else {
                    I_C_Invoice mInvoice2 = mPayment.getC_Invoice();
                    if (mInvoice2.getGrandTotal().equals(bdLineNetAmt)) {
                        mPayment.setC_BankAccount_ID(LIT_BankAccAdv_ID);
                    }
                }
            }
        }
        if (po instanceof X_C_Invoice && type == 5 && (mInvoice = (X_C_Invoice)po).is_ValueChanged("Processed") && mInvoice.isProcessed() && !mInvoice.isPaid() && (mPara = MLITAdvInvPara.get(po.getCtx(), po.getAD_Client_ID())) != null && mInvoice.getC_DocTypeTarget_ID() == mPara.getC_DocAdvInv_ID()) {
            MPayment mPayment = new MPayment(po.getCtx(), 0, po.get_TrxName());
            mPayment.setC_DocType_ID(mPara.getC_DocTypeArr_ID());
            mPayment.setC_BankAccount_ID(IADVMInvoice.getC_BankAccount_ID(mInvoice));
            mPayment.setC_BPartner_ID(mInvoice.getC_BPartner_ID());
            mPayment.setC_Invoice_ID(mInvoice.getC_Invoice_ID());
            mPayment.setC_Currency_ID(mInvoice.getC_Currency_ID());
            mPayment.setPayAmt(mInvoice.getGrandTotal());
            mPayment.setDateAcct(mInvoice.getDateAcct());
            mPayment.setTrxType("S");
            mPayment.setTenderType("K");
            mPayment.saveEx();
            mPayment.processIt("CO");
            mPayment.saveEx();
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        if (po instanceof X_C_Payment && timing == 9) {
            int ILC_InvoiceLine_ID;
            String sChAdvPolicy;
            boolean bIsPayOnAdvAcc;
            BigDecimal bdAdvPerc;
            BigDecimal bdChAdvValue;
            BigDecimal bdLineNetAmt;
            ResultSet rs;
            CPreparedStatement pstmt;
            X_C_Payment mPayment;
            block23: {
                mPayment = (X_C_Payment)po;
                String sSQL = QueryRepo.getQuery(SQL_INVADVPERCVALUE, this.getClass().getClassLoader());
                pstmt = DB.prepareStatement(sSQL, po.get_TrxName());
                rs = null;
                bdLineNetAmt = null;
                bdChAdvValue = null;
                bdAdvPerc = null;
                bIsPayOnAdvAcc = false;
                sChAdvPolicy = null;
                ILC_InvoiceLine_ID = -1;
                try {
                    pstmt.setInt(1, mPayment.getC_Invoice_ID());
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block23;
                    bdLineNetAmt = rs.getBigDecimal("LineNetAmt");
                    String sIsPayOnAdvAcc = rs.getString("LIT_IsPayOnAdvAcc");
                    sChAdvPolicy = rs.getString("LIT_ChAdvPolicy");
                    bdChAdvValue = rs.getBigDecimal("LIT_ChAdvValue");
                    bdAdvPerc = rs.getBigDecimal("LIT_AdvPerc");
                    ILC_InvoiceLine_ID = rs.getInt("C_InvoiceLine_ID");
                    if (sIsPayOnAdvAcc != null && sIsPayOnAdvAcc.equals("Y")) {
                        bIsPayOnAdvAcc = true;
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new AdempiereException(e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        throw throwable;
                    }
                }
            }
            DB.close(rs, pstmt);
            if (bdLineNetAmt != null) {
                MInvoice mInvoice = MInvoice.get(mPayment.getCtx(), mPayment.getC_Invoice_ID());
                Query qInvLine = new Query(po.getCtx(), "C_InvoiceLine", "C_InvoiceLine_ID = ?", po.get_TrxName());
                qInvLine.setParameters(ILC_InvoiceLine_ID);
                X_C_InvoiceLine mAdvInvLine = (X_C_InvoiceLine)qInvLine.first();
                BigDecimal bdCurrentLineAdvValue = IADVMInvoiceLine.getLIT_ChAdvValue(mAdvInvLine);
                if (bdLineNetAmt.compareTo(mInvoice.getGrandTotal()) < 0) {
                    BigDecimal bdAdvValue = null;
                    BigDecimal bdDeltaAdvValue = bdLineNetAmt.subtract(bdChAdvValue);
                    if (bIsPayOnAdvAcc) {
                        bdAdvValue = mPayment.getPayAmt().subtract(bdDeltaAdvValue);
                        if (bdAdvValue.signum() < 0) {
                            bdAdvValue = BigDecimal.ZERO;
                            IADVMInvoiceLine.setLIT_ChAdvValue(mAdvInvLine, bdCurrentLineAdvValue.add(mPayment.getPayAmt()));
                        } else {
                            IADVMInvoiceLine.setLIT_ChAdvValue(mAdvInvLine, bdLineNetAmt);
                        }
                    } else if (sChAdvPolicy.equals("R")) {
                        BigDecimal bdPayPercOfValue = mPayment.getPayAmt().multiply(bdAdvPerc.divide(Env.ONEHUNDRED, 50, RoundingMode.HALF_UP));
                        if (bdDeltaAdvValue.compareTo(bdPayPercOfValue) <= 0) {
                            bdAdvValue = bdDeltaAdvValue;
                            IADVMInvoiceLine.setLIT_ChAdvValue(mAdvInvLine, bdLineNetAmt);
                        } else {
                            bdAdvValue = bdPayPercOfValue;
                            IADVMInvoiceLine.setLIT_ChAdvValue(mAdvInvLine, bdCurrentLineAdvValue.add(bdPayPercOfValue));
                        }
                    } else if (sChAdvPolicy.equals("F") && mInvoice.getOpenAmt().equals(mInvoice.getGrandTotal())) {
                        bdAdvValue = bdLineNetAmt;
                        IADVMInvoiceLine.setLIT_ChAdvValue(mAdvInvLine, bdLineNetAmt);
                    } else if (mInvoice.getOpenAmt().subtract(mPayment.getPayAmt()).signum() == 0) {
                        bdAdvValue = bdLineNetAmt;
                        IADVMInvoiceLine.setLIT_ChAdvValue(mAdvInvLine, bdLineNetAmt);
                    }
                    if (bdAdvValue != null && bdAdvValue.signum() > 0) {
                        MLITAdvInvPara mPara = MLITAdvInvPara.get(po.getCtx(), po.getAD_Client_ID());
                        int iTo_C_BankAccount_ID = -1;
                        if (bIsPayOnAdvAcc) {
                            Query qBA = new Query(mPayment.getCtx(), "C_BankAccount", "LIT_BankAccAdv_ID = ?", mPayment.get_TrxName());
                            qBA.setParameters(mPayment.getC_BankAccount_ID());
                            iTo_C_BankAccount_ID = qBA.firstId();
                        } else {
                            MBankAccount mBAPayment = MBankAccount.get(mPayment.getCtx(), mPayment.getC_BankAccount_ID());
                            Query qBA = new Query(mPayment.getCtx(), "C_BankAccount", "C_BankAccount_ID = ?", mPayment.get_TrxName());
                            qBA.setParameters(IADVMBankAccount.getLIT_BankAccAdv_ID(mBAPayment));
                            iTo_C_BankAccount_ID = qBA.firstId();
                        }
                        this.generateBankTransfer(mPayment, mInvoice, mPara, iTo_C_BankAccount_ID, bdAdvValue);
                    }
                } else {
                    IADVMInvoiceLine.setLIT_ChAdvValue(mAdvInvLine, bdCurrentLineAdvValue.add(mPayment.getPayAmt()));
                }
                mAdvInvLine.saveEx();
            }
        }
        return null;
    }

    private void generateBankTransfer(X_C_Payment mPayment, I_C_Invoice mInvoice, MLITAdvInvPara mPara, int iTo_C_BankAccount_ID, BigDecimal bdAmount) {
        MBankAccount mBankFrom = new MBankAccount(mPayment.getCtx(), mPayment.getC_BankAccount_ID(), mPayment.get_TrxName());
        MBankAccount mBankTo = new MBankAccount(mPayment.getCtx(), iTo_C_BankAccount_ID, mPayment.get_TrxName());
        String sDescFormat = Msg.getMsg(mPayment.getCtx(), "LIT_InvAdv_DESC_InvAdvBankTransfer");
        String sDesc = MessageFormat.format(sDescFormat, mInvoice.getDocumentNo(), mInvoice.getDateInvoiced());
        String sDocNo = SequenceHelper.getDocumentNo(mPayment.getAD_Client_ID(), mPara.getAD_Sequence_ID(), mPayment.get_TrxName(), mPayment);
        MPayment paymentBankFrom = new MPayment(mPayment.getCtx(), 0, mPayment.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(mBankFrom.getC_BankAccount_ID());
        paymentBankFrom.setDocumentNo(sDocNo);
        paymentBankFrom.setDateAcct(mPayment.getDateAcct());
        paymentBankFrom.setDateTrx(mPayment.getDateTrx());
        paymentBankFrom.setTenderType("A");
        paymentBankFrom.setDescription(sDesc);
        paymentBankFrom.setC_BPartner_ID(mPayment.getC_BPartner_ID());
        paymentBankFrom.setC_Currency_ID(mPayment.getC_Currency_ID());
        paymentBankFrom.setPayAmt(bdAmount);
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(mPara.getC_Charge_ID());
        paymentBankFrom.save();
        paymentBankFrom.processIt("CO");
        paymentBankFrom.saveEx();
        MPayment paymentBankTo = new MPayment(mPayment.getCtx(), 0, mPayment.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(mBankTo.getC_BankAccount_ID());
        paymentBankTo.setDocumentNo(sDocNo);
        paymentBankTo.setDateAcct(mPayment.getDateAcct());
        paymentBankTo.setDateTrx(mPayment.getDateTrx());
        paymentBankTo.setTenderType("A");
        paymentBankTo.setDescription(sDesc);
        paymentBankTo.setC_BPartner_ID(mPayment.getC_BPartner_ID());
        paymentBankTo.setC_Currency_ID(mPayment.getC_Currency_ID());
        paymentBankTo.setPayAmt(bdAmount);
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(mPara.getC_Charge_ID());
        paymentBankTo.save();
        paymentBankTo.processIt("CO");
        paymentBankTo.saveEx();
    }
}

