/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.invoiceadv.model;

import com.f3p.adempiere.invoiceadv.model.IADVMInvoice;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInvoice;
import org.compiere.util.Env;

public class InvAdvCallout
extends CalloutEngine {
    public String advPercInvoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal bdGrandAmount = (BigDecimal)mTab.getValue("GrandTotal");
        return this.advPerc(mTab, value, bdGrandAmount, new String[]{"LIT_AdvValue"});
    }

    public String advPercInvoiceLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MInvoice mInv;
        Integer C_Invoice_ID = (Integer)mTab.getValue("LIT_AdvInv_ID");
        if (C_Invoice_ID != null && C_Invoice_ID > 0 && (mInv = MInvoice.get(ctx, C_Invoice_ID)) != null) {
            BigDecimal bdGrandAmount = mInv.getGrandTotal();
            return this.advPerc(mTab, value, bdGrandAmount, new String[]{"PriceEntered", "PriceActual", "LineNetAmt"});
        }
        return "";
    }

    public String bankOfInvoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int C_BankAccount_ID;
        MInvoice mInv;
        Integer C_Invoice_ID = (Integer)value;
        if (C_Invoice_ID != null && C_Invoice_ID > 0 && (mInv = MInvoice.get(ctx, C_Invoice_ID)) != null && (C_BankAccount_ID = IADVMInvoice.getC_BankAccount_ID(mInv)) > 0) {
            mTab.setValue("C_BankAccount_ID", (Object)C_BankAccount_ID);
        }
        return "";
    }

    protected String advPerc(GridTab mTab, Object value, BigDecimal bdSrcValue, String[] sTrargetFields) {
        BigDecimal bdPerc = (BigDecimal)value;
        if (bdPerc.compareTo(Env.ZERO) < 0) {
            bdPerc = BigDecimal.ZERO;
        }
        if (bdPerc.compareTo(Env.ONEHUNDRED) > 0) {
            bdPerc = Env.ONEHUNDRED;
        }
        BigDecimal bdValue = bdSrcValue.multiply(bdPerc.divide(Env.ONEHUNDRED, 30, RoundingMode.HALF_UP));
        for (String sField : sTrargetFields) {
            mTab.setValue(sField, (Object)bdValue.setScale(2, RoundingMode.HALF_UP));
        }
        return "";
    }
}

