/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.invoiceadv.form;

import com.f3p.adempiere.invoiceadv.Messages;
import com.f3p.adempiere.invoiceadv.model.IADVMBank;
import com.f3p.adempiere.invoiceadv.model.IADVMInvoice;
import com.f3p.adempiere.invoiceadv.model.IADVMInvoiceLine;
import com.f3p.adempiere.util.IDResolver;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.ADialog;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.search.AbstractInfo;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.I_C_Currency;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLITAdvInvPara;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class GenerateInvAdv
extends AbstractInfo
implements FormPanel,
Messages {
    private static final int FILTER_BANKACCOUNT = 0;
    private static final int FILTER_PERC = 1;
    private static final long serialVersionUID = 1093859275757534207L;
    private static final Info_Column[] LIST_LAYOUT = new Info_Column[]{new Info_Column(" ", "C_Invoice_ID", IDColumn.class, false), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "BPName", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "DocumentNo", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "DateInvoiced"), "DateInvoiced", Timestamp.class, true), new Info_Column(Msg.translate(Env.getCtx(), "C_PaymentTerm_ID"), "PaymentName", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "C_Currency_ID"), "CurrencyName", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "GrandTotal"), "GrandTotal", BigDecimal.class, true), new Info_Column(Msg.translate(Env.getCtx(), "Description"), "Description", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "POReference"), "POREFERENCE", String.class, true)};
    protected VDate m_vdDateFrom = new VDate(15);
    protected VDate m_vdDateTo = new VDate(15);
    protected VCheckBox m_vbSelectAll = new VCheckBox();

    @Override
    public void initialize() {
        int iColBankAccount = IDResolver.getAD_Column_ID("C_BankStatement", "C_BankAccount_ID");
        int iColBPartner = IDResolver.getAD_Column_ID("C_Invoice", "C_BPartner_ID");
        int iColAdvPerc = IDResolver.getAD_Column_ID("C_InvoiceLine", "LIT_AdvPerc");
        this.addFilter(iColBankAccount);
        this.setFilterQuery(0, "(ISL.C_BANKACCOUNT_ID = ? or ISL.C_BANKACCOUNT_ID is null)");
        this.addFilter(iColAdvPerc);
        this.setFilterAsUIOnly(1, true);
        this.setLineBreakOnFilter(1, true);
        this.addFilter(iColBPartner);
        this.addFilter("DateFrom", this.m_vdDateFrom, "ISL.DateInvoiced >= ?", false);
        this.addFilter("DateTo", this.m_vdDateTo, "ISL.DateInvoiced <= ?", false);
        this.setLineBreakOnFilter(4, true);
        this.m_vbSelectAll.addVetoableChangeListener(this);
        this.m_vbSelectAll.setText(Msg.getMsg(Env.getCtx(), "select.all"));
        this.addUIElement(this.m_vbSelectAll, null, false);
        super.initialize();
        this.getFilterEditor(3).removeVetoableChangeListener(this);
        this.getFilterEditor(4).removeVetoableChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Ok")) {
            Properties ctx = Env.getCtx();
            Integer C_BankAccount_ID = (Integer)this.getFilterValue(0);
            if (C_BankAccount_ID == null || C_BankAccount_ID <= 0) {
                ADialog.error(this.p_WindowNo, this, "LIT_InvAdv_ERR_MissingBankAccount");
                return;
            }
            MLITAdvInvPara mPara = MLITAdvInvPara.get(ctx, Env.getAD_Client_ID(ctx));
            if (mPara == null) {
                ADialog.error(this.p_WindowNo, this, "LIT_InvAdv_ERR_MissingAdvInvPara");
                return;
            }
            BigDecimal bdPerc = (BigDecimal)this.getFilterValue(1);
            if (bdPerc == null || bdPerc.signum() <= 0) {
                ADialog.error(this.p_WindowNo, this, "LIT_InvAdv_ERR_InvalidPerc");
                return;
            }
            String sTrx = Trx.createTrxName();
            int iNumRows = this.p_table.getRowCount();
            int iLineNo = 10;
            boolean bAtLeastOneSel = false;
            int C_Invoice_ID = -1;
            for (int i = 0; i < iNumRows; ++i) {
                IDColumn idInvoice = (IDColumn)this.p_table.getValueAt(i, 0);
                if (idInvoice == null || !idInvoice.isSelected()) continue;
                bAtLeastOneSel = true;
                break;
            }
            if (bAtLeastOneSel) {
                try {
                    MInvoice mInvoice = this.createInvoice(ctx, C_BankAccount_ID, mPara, sTrx);
                    for (int i = 0; i < iNumRows; ++i) {
                        IDColumn idInvoice = (IDColumn)this.p_table.getValueAt(i, 0);
                        if (idInvoice == null || !idInvoice.isSelected()) continue;
                        MInvoice mInputInvoice = MInvoice.get(ctx, idInvoice.getRecord_ID());
                        this.createLine(mInputInvoice, bdPerc, mInvoice, mPara, iLineNo);
                        iLineNo += 10;
                    }
                    C_Invoice_ID = mInvoice.getC_Invoice_ID();
                }
                finally {
                    try {
                        if (C_Invoice_ID > 0) {
                            DB.commit(true, sTrx);
                        } else {
                            DB.rollback(true, sTrx);
                        }
                    }
                    catch (SQLException e) {
                        throw new AdempiereException(e);
                    }
                }
                if (C_Invoice_ID > 0) {
                    this.dispose();
                    MQuery query = new MQuery("C_Invoice");
                    query.addRestriction("C_Invoice_ID", "=", C_Invoice_ID);
                    query.setRecordCount(1);
                    int AD_WindowNo = this.getAD_Window_ID("C_Invoice", true);
                    this.zoom(AD_WindowNo, query);
                }
            }
        } else {
            super.actionPerformed(event);
        }
    }

    protected MInvoice createInvoice(Properties ctx, int C_BankAccount_ID, MLITAdvInvPara mPara, String sTrx) {
        MInvoice mInvoice = new MInvoice(ctx, 0, sTrx);
        Timestamp tsNow = TimeUtil.getDay(System.currentTimeMillis());
        MBankAccount mBankAccount = MBankAccount.get(ctx, C_BankAccount_ID);
        MBank mBank = mBankAccount.getBank();
        MBPartner mBPartner = MBPartner.get(ctx, IADVMBank.getC_BPartner_ID(mBank));
        MBPartnerLocation mBPLocation = null;
        int M_PriceList_ID = Env.getContextAsInt(ctx, "M_PriceList_ID");
        int C_ConversionType_ID = Env.getContextAsInt(ctx, "C_ConversionType_ID");
        for (MBPartnerLocation mLoc : mBPartner.getLocations(true)) {
            if (!mLoc.isBillTo()) continue;
            mBPLocation = mLoc;
            break;
        }
        if (mBPLocation == null) {
            throw new AdempiereException("@LIT_InvAdv_ERR_BankBPLocationNotFound@");
        }
        mInvoice.setIsSOTrx(true);
        mInvoice.setC_DocTypeTarget_ID(mPara.getC_DocAdvInv_ID());
        mInvoice.setSalesRep_ID(Env.getAD_User_ID(ctx));
        mInvoice.setDateInvoiced(tsNow);
        mInvoice.setDateAcct(tsNow);
        mInvoice.setC_BPartner_ID(mBPartner.getC_BPartner_ID());
        mInvoice.setC_BPartner_Location_ID(mBPLocation.getC_BPartner_Location_ID());
        mInvoice.setC_Currency_ID(mBankAccount.getC_Currency_ID());
        mInvoice.setPaymentRule("P");
        mInvoice.setC_PaymentTerm_ID(mPara.getC_PaymentTerm_ID());
        mInvoice.setM_PriceList_ID(M_PriceList_ID);
        mInvoice.setC_ConversionType_ID(C_ConversionType_ID);
        IADVMInvoice.setC_BankAccount_ID(mInvoice, C_BankAccount_ID);
        mInvoice.saveEx();
        return mInvoice;
    }

    protected MInvoiceLine createLine(MInvoice mInputInvoice, BigDecimal bdPerc, MInvoice mAdvInvoice, MLITAdvInvPara mPara, int iLineNo) {
        MProduct mProduct = mPara.getProduct();
        MInvoiceLine mLine = new MInvoiceLine(mAdvInvoice);
        mLine.setLine(iLineNo);
        mLine.setM_Product_ID(mProduct.getM_Product_ID());
        mLine.setC_UOM_ID(mProduct.getC_UOM_ID());
        mLine.setQty(BigDecimal.ONE);
        I_C_Currency mCurrency = mAdvInvoice.getC_Currency();
        BigDecimal bdPriceEntered = mInputInvoice.getGrandTotal();
        bdPriceEntered = MConversionRate.convert(mAdvInvoice.getCtx(), bdPriceEntered, mInputInvoice.getC_Currency_ID(), mAdvInvoice.getC_Currency_ID(), mAdvInvoice.getAD_Client_ID(), mAdvInvoice.getAD_Org_ID());
        bdPriceEntered = bdPriceEntered.multiply(bdPerc).divide(Env.ONEHUNDRED, mCurrency.getStdPrecision(), RoundingMode.HALF_UP);
        mLine.setPrice(bdPriceEntered);
        IADVMInvoiceLine.setLIT_AdvInv_ID(mLine, mInputInvoice.getC_Invoice_ID());
        IADVMInvoiceLine.setLIT_AdvPerc(mLine, bdPerc);
        mLine.saveEx();
        return mLine;
    }

    @Override
    public String getOrderBy() {
        return "DocumentNo";
    }

    @Override
    public String getQueryName() {
        return "com/f3p/adempiere/invoiceadv/form/get_invoices";
    }

    @Override
    public Info_Column[] getTableLayout() {
        return LIST_LAYOUT;
    }

    @Override
    public String getTableName() {
        return "ISL";
    }

    @Override
    public boolean isMultiSelectable() {
        return true;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == this.m_vbSelectAll) {
            boolean bCheck = (Boolean)evt.getNewValue();
            int iRows = this.p_table.getRowCount();
            for (int i = 0; i < iRows; ++i) {
                IDColumn idc = (IDColumn)this.p_table.getValueAt(i, 0);
                if (idc == null) continue;
                idc.setSelected(bCheck);
                this.p_table.setValueAt(idc, i, 0);
            }
        } else if (evt.getSource() == this.getFilterEditor(1)) {
            BigDecimal bdNewVal = (BigDecimal)evt.getNewValue();
            if (bdNewVal.signum() < 0) {
                this.setFilterValue(1, BigDecimal.ZERO);
            } else if (bdNewVal.compareTo(Env.ONEHUNDRED) > 0) {
                this.setFilterValue(1, Env.ONEHUNDRED);
            }
        } else {
            super.vetoableChange(evt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            return;
        }
        super.mouseClicked(evt);
    }
}

