/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.file;

import com.f3p.adempiere.model.MReportDef;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.report.ReportProcess;
import com.f3p.adempiere.report.engine.JasperEngine;
import com.f3p.adempiere.report.engine.OOEngine;
import java.io.File;
import java.util.Properties;
import org.compiere.process.ProcessInfo;

public class FileBuilder {
    protected ProcessInfo m_processInfo;
    protected OOEngine m_engineOO = new OOEngine();
    protected JasperEngine m_engineJasper = new JasperEngine();
    protected ReportProcess m_process;

    public FileBuilder(ReportProcess reportProcess) {
        this(reportProcess, reportProcess.getProcessInfo());
    }

    public FileBuilder(ReportProcess reportProcess, ProcessInfo pInfo) {
        this.m_process = reportProcess;
        this.m_processInfo = pInfo;
    }

    public File getAsPDF(MReportDet mReportDet, Properties ctx, int WindowNo, int TabNo) throws Exception {
        File fRepAtt;
        MReportDef def = mReportDet.getDefinition();
        File fPDF = null;
        if (def != null && (fRepAtt = def.getReportFile()) != null) {
            if (def.getMotore().equals("O")) {
                fPDF = this.m_engineOO.createPDF(this.m_process, mReportDet, def);
            } else if (def.getMotore().equals("J")) {
                fPDF = this.m_engineJasper.createPDF(this.m_process, mReportDet, def);
            }
            if (!fRepAtt.delete()) {
                fRepAtt.deleteOnExit();
            }
        }
        return fPDF;
    }

    public File getAsHTML(MReportDet mReportDet, Properties ctx, int WindowNo, int TabNo) throws Exception {
        File fRepAtt;
        MReportDef def = mReportDet.getDefinition();
        File fHtml = null;
        if (def != null && (fRepAtt = def.getReportFile()) != null) {
            if (def.getMotore().equals("O")) {
                fHtml = this.m_engineOO.createHTML(this.m_process, mReportDet, def);
            } else if (def.getMotore().equals("J")) {
                fHtml = this.m_engineJasper.createHTML(this.m_process, mReportDet, def);
            }
            fRepAtt.delete();
        }
        return fHtml;
    }
}

