/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.dataprovider;

import com.f3p.adempiere.dataprovider.DataSourceWrapper;
import com.f3p.commons.Utils;
import com.f3p.dataprovider.DataProviderConfig;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class DataProviderUtil {
    private static final String CACHE_KEY = "com.f3p.adempiere.dataprovider.CachedDataProvider";
    public static final String STANDARD_ENCODING = "UTF8";
    public static final String CONNECTIONNAME = "adempiere";
    public static final String CONFIG_LOCATION_SYSC = "DATAPROVIDER_LOCATION";
    public static final String CONFIG_LOCATION_PROPERTY = "com.f3p.adempiere.dataprovider.location";
    public static final String DEFAULT_CONFIG_LOCATION = "/com/f3p/adempiere/resources/dataprovider-config.xml";
    private static CLogger s_logger = CLogger.getCLogger(DataProviderUtil.class);

    public static boolean isHttpConfigLocation(String sLocation) {
        return sLocation.startsWith("http:") || sLocation.startsWith("https");
    }

    public static InputStream getConfigAsInputStream(int AD_Client_ID, int AD_Org_ID) {
        String sLocation = System.getProperty(CONFIG_LOCATION_PROPERTY, null);
        if (sLocation == null) {
            sLocation = MSysConfig.getValue(CONFIG_LOCATION_SYSC, null, AD_Client_ID, AD_Org_ID);
        }
        if (sLocation == null) {
            sLocation = DEFAULT_CONFIG_LOCATION;
        }
        if (DataProviderUtil.isHttpConfigLocation(sLocation)) {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            String sConfig = null;
            ByteArrayInputStream is = null;
            try {
                try {
                    HttpGet get = new HttpGet(sLocation);
                    BasicResponseHandler responseHandler = new BasicResponseHandler();
                    sConfig = (String)httpClient.execute((HttpUriRequest)get, (ResponseHandler)responseHandler);
                    if (!Utils.isEmptyString(sConfig)) {
                        is = new ByteArrayInputStream(sConfig.getBytes(STANDARD_ENCODING));
                    }
                }
                catch (Exception e) {
                    throw new AdempiereException(e);
                }
            }
            finally {
                httpClient.getConnectionManager().shutdown();
            }
            return is;
        }
        return DataProviderUtil.class.getResourceAsStream(sLocation);
    }

    protected static DataProviderConfig loadDefaultConfig(int AD_Client_ID, int AD_Org_ID) {
        DataProviderConfig dpc = null;
        InputStream isDefaultConfig = DataProviderUtil.getConfigAsInputStream(AD_Client_ID, AD_Org_ID);
        try {
            dpc = new DataProviderConfig(isDefaultConfig);
            dpc.registerConnectionObject(CONNECTIONNAME, new DataSourceWrapper());
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "DataProviderUtil.loadDefaultConfig", t);
        }
        return dpc;
    }

    public static synchronized DataProviderConfig getDataProvider() {
        Properties ctx = Env.getCtx();
        DataProviderConfig cachedDataProvider = (DataProviderConfig)ctx.get(CACHE_KEY);
        if (cachedDataProvider == null) {
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            int AD_Org_ID = Env.getAD_Org_ID(ctx);
            cachedDataProvider = DataProviderUtil.loadDefaultConfig(AD_Client_ID, AD_Org_ID);
            Env.getCtx().put(CACHE_KEY, cachedDataProvider);
        }
        return cachedDataProvider;
    }

    public DataProviderConnection getDataProviderConnection(String sName) {
        return DataProviderUtil.getDataProvider().getConnection(sName);
    }

    public synchronized void loadAdditionalDPConfig(URL config) throws DataProviderException {
        DataProviderUtil.getDataProvider().loadConfig(config);
    }

    public synchronized void loadAdditionalDPConfig(InputStream is) throws DataProviderException {
        DataProviderUtil.getDataProvider().loadConfig(is);
    }

    public synchronized void loadAdditionalDPConfig(String sClassPath) throws DataProviderException, IOException {
        InputStream is = this.getClass().getResourceAsStream(sClassPath);
        try {
            this.loadAdditionalDPConfig(is);
        }
        finally {
            is.close();
        }
    }
}

