/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.crm.process;

import com.f3p.adempiere.crm.model.CRMMRequest;
import com.f3p.adempiere.crm.model.X_F3P_Request_BPInfo;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MRequest;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class CreateFromBPInfo
extends SvrProcess {
    protected X_F3P_Request_BPInfo m_RequestBPInfo;
    private static final String AD_ERROR_CREATION_MESSAGE = "CRM_Creation_From_BPInfo_Failed";
    private static final String AD_SUCCESS_CREATION_MESSAGE = "Success";

    @Override
    protected String doIt() throws Exception {
        String sMsg = null;
        boolean bError = false;
        int iR_Request_ID = this.m_RequestBPInfo.getR_Request_ID();
        if (iR_Request_ID > 0) {
            try {
                int iC_BPartner_Location_ID;
                int iAD_User_ID;
                MRequest mRequest = this.getRequest(iR_Request_ID);
                int iC_BPartner_ID = mRequest.getC_BPartner_ID();
                if (iC_BPartner_ID <= 0) {
                    iC_BPartner_ID = this.createBusinessPartner();
                    mRequest.setC_BPartner_ID(iC_BPartner_ID);
                }
                if ((iAD_User_ID = mRequest.getAD_User_ID()) <= 0 && this.m_RequestBPInfo.getContact_Name() != null) {
                    iAD_User_ID = this.createBPContact(iC_BPartner_ID);
                    mRequest.setAD_User_ID(iAD_User_ID);
                }
                if ((iC_BPartner_Location_ID = CRMMRequest.getC_BPartner_Location_ID(mRequest)) <= 0) {
                    int iC_Location = this.getLocationID();
                    iC_BPartner_Location_ID = this.createBPLocation(iC_BPartner_ID, iC_Location);
                    CRMMRequest.setC_BPartner_Location_ID(mRequest, iC_BPartner_Location_ID);
                    MBPartnerLocation mBPLocation = this.getBPartnerLocation(iC_BPartner_Location_ID);
                    this.m_RequestBPInfo.setLoc_Name(mBPLocation.getName());
                    this.m_RequestBPInfo.saveEx();
                }
                if (mRequest.save()) {
                    DB.commit(true, this.get_TrxName());
                } else {
                    DB.rollback(true, this.get_TrxName());
                    bError = true;
                }
            }
            catch (Exception e) {
                DB.rollback(true, this.get_TrxName());
                bError = true;
            }
        }
        sMsg = bError ? Msg.getMsg(this.getCtx(), AD_ERROR_CREATION_MESSAGE) : Msg.getMsg(this.getCtx(), AD_SUCCESS_CREATION_MESSAGE);
        return sMsg;
    }

    protected int createBusinessPartner() {
        MBPartner mBPartner = new MBPartner(this.getCtx(), 0, this.get_TrxName());
        mBPartner.setName(this.m_RequestBPInfo.getBP_Name());
        mBPartner.setTaxID(this.m_RequestBPInfo.getTaxID());
        mBPartner.saveEx();
        return mBPartner.getC_BPartner_ID();
    }

    protected int createBPContact(int C_BPartner_ID) {
        MBPartner mBPartner = this.getBPartner(C_BPartner_ID);
        MUser mUser = new MUser(mBPartner);
        mUser.setName(this.m_RequestBPInfo.getContact_Name());
        mUser.setEMail(this.m_RequestBPInfo.getEMail());
        mUser.setPhone(this.m_RequestBPInfo.getPhone());
        mUser.setFax(this.m_RequestBPInfo.getFax());
        int iC_Job_ID = this.m_RequestBPInfo.getC_Job_ID();
        if (iC_Job_ID > 0) {
            mUser.setC_Job_ID(iC_Job_ID);
        }
        mUser.saveEx();
        return mUser.getAD_User_ID();
    }

    protected int createLocation() {
        MLocation mLocation = new MLocation(this.getCtx(), 0, this.get_TrxName());
        mLocation.setAddress1(this.m_RequestBPInfo.getAddress());
        mLocation.setCity(this.m_RequestBPInfo.getCity());
        mLocation.setPostal(this.m_RequestBPInfo.getPostal());
        mLocation.setC_Country_ID(this.m_RequestBPInfo.getC_Country_ID());
        mLocation.setC_Region_ID(this.m_RequestBPInfo.getC_Region_ID());
        mLocation.saveEx();
        return mLocation.getC_Location_ID();
    }

    protected int createBPLocation(int C_BPartner_ID, int C_Location_ID) {
        MBPartner mBPartner = this.getBPartner(C_BPartner_ID);
        MBPartnerLocation mBPLocation = new MBPartnerLocation(mBPartner);
        mBPLocation.setC_Location_ID(C_Location_ID);
        mBPLocation.setPhone(this.m_RequestBPInfo.getPhone());
        mBPLocation.setFax(this.m_RequestBPInfo.getFax());
        mBPLocation.saveEx();
        return mBPLocation.getC_BPartner_Location_ID();
    }

    protected int getLocationID() {
        int C_Location_ID = -1;
        String sAddress = this.filterString(this.m_RequestBPInfo.getAddress(), false);
        String sCity = this.filterString(this.m_RequestBPInfo.getCity(), false);
        Query q = new Query(this.getCtx(), "C_Location", "lower(Address1) like ? AND lower(City) like ? AND C_Region_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sAddress, sCity, this.m_RequestBPInfo.getC_Region_ID());
        C_Location_ID = q.count() > 0 ? q.firstId() : this.createLocation();
        return C_Location_ID;
    }

    @Override
    protected void prepare() {
        int requestBPInfoID = this.getRecord_ID();
        this.m_RequestBPInfo = new X_F3P_Request_BPInfo(this.getCtx(), requestBPInfoID, this.get_TrxName());
    }

    protected MRequest getRequest(int R_Request_ID) {
        Query q = new Query(this.getCtx(), "R_Request", "R_Request_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(R_Request_ID);
        return (MRequest)q.first();
    }

    protected MBPartner getBPartner(int C_BPartner_ID) {
        Query q = new Query(this.getCtx(), "C_BPartner", "C_BPartner_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(C_BPartner_ID);
        return (MBPartner)q.first();
    }

    protected MBPartnerLocation getBPartnerLocation(int C_BPartner_Location_ID) {
        Query q = new Query(this.getCtx(), "C_BPartner_Location", "C_BPartner_Location_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(C_BPartner_Location_ID);
        return (MBPartnerLocation)q.first();
    }

    protected String filterString(String toFilter, boolean bIsNumber) {
        toFilter = toFilter.toLowerCase().replaceAll(" ", "_");
        toFilter = !bIsNumber ? toFilter.replaceAll("[^0-9a-zA-z]", "_") : toFilter.replaceAll("[^0-9]", "_");
        return toFilter;
    }
}

