/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cmdtools;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class UpdatePackages {
    public static final String PACKAGES = "packages";
    public static final String ZKPACKAGES = "zkpackages";
    public static final String LIB = "lib";
    public static final char VERSION_SEP_CHAR = '-';
    public static SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    protected String m_sDateBackupPart;
    protected File m_fBackupPath;
    protected File m_fAdempiereHome;
    protected File m_fUpdateDir;

    public UpdatePackages(File fBackupPath, File fAdempiereHome, File fBaseUpdatePath) {
        this.m_fBackupPath = fBackupPath;
        this.m_fAdempiereHome = fAdempiereHome;
        this.m_fUpdateDir = fBaseUpdatePath;
        this.m_sDateBackupPart = BACKUP_DATE_FORMAT.format(new Date(System.currentTimeMillis()));
    }

    public File getInstalledModule(String sDir, File newModule) throws IOException {
        char chVersion;
        File fDirToCheck = new File(this.m_fAdempiereHome, sDir);
        String sName = newModule.getName();
        int iVersionSepIdx = sName.lastIndexOf(45);
        boolean bExactMatch = true;
        if (!newModule.exists()) {
            throw new IOException("New module not existing: " + newModule.toString());
        }
        if (iVersionSepIdx > 0 && Character.isDigit(chVersion = sName.charAt(iVersionSepIdx + 1))) {
            sName = sName.substring(0, iVersionSepIdx);
            bExactMatch = false;
        }
        ArrayList<File> lstMatchedFiles = new ArrayList<File>();
        File[] fileArray = fDirToCheck.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fCurrentFile = fileArray[n2];
            boolean bMatch = false;
            bMatch = bExactMatch ? fCurrentFile.getName().equals(sName) : fCurrentFile.getName().startsWith(sName);
            if (bMatch) {
                lstMatchedFiles.add(fCurrentFile);
            }
            ++n2;
        }
        if (lstMatchedFiles.size() == 0) {
            return null;
        }
        if (lstMatchedFiles.size() == 1) {
            return (File)lstMatchedFiles.get(0);
        }
        StringBuffer sbMatches = new StringBuffer();
        for (File fMatch : lstMatchedFiles) {
            sbMatches.append(fMatch.toString()).append(',');
        }
        throw new IOException("Found more then one match for " + sName + "; " + sbMatches.toString());
    }

    public File getBackupPath(String sDir) throws IOException {
        File fDateBackup = new File(this.m_fBackupPath, this.m_sDateBackupPart);
        File fFullBackup = new File(fDateBackup, sDir);
        if (!fFullBackup.mkdirs()) {
            throw new IOException("Impossible to create backup path: " + fFullBackup.toString());
        }
        return fFullBackup;
    }

    public void backupAndMove(String sDir) throws IOException {
        File fBase = new File(this.m_fUpdateDir, sDir);
        File fMoveTo = new File(this.m_fAdempiereHome, sDir);
        if (!fBase.exists()) {
            this.log("Skipping " + sDir + ", does not exists");
            return;
        }
        File fBackupPath = this.getBackupPath(sDir);
        File[] fileArray = fBase.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fChild = fileArray[n2];
            if (!fChild.getName().equals(".") && !fChild.getName().equals("..")) {
                File fMoved;
                File fInstalled = this.getInstalledModule(sDir, fChild);
                if (fInstalled != null) {
                    File fBackupFile = new File(fBackupPath, fInstalled.getName());
                    if (!fInstalled.renameTo(fBackupFile)) {
                        throw new IOException("Impossible to backup " + fInstalled + " to " + fBackupFile.toString());
                    }
                    this.log("Created backup: " + fBackupFile.toString());
                }
                if (!fChild.renameTo(fMoved = new File(fMoveTo, fChild.getName()))) {
                    throw new IOException("Impossible to move " + fChild + " to " + fMoved.toString());
                }
                this.log("Moved: " + fMoved.toString());
            }
            ++n2;
        }
    }

    public void log(String sMessage) {
        System.out.println(sMessage);
    }

    public static void main(String[] args) throws IOException {
        File fBackup = new File(args[0]);
        File fAdempiereHome = new File(args[1]);
        File fUpdatePath = new File(System.getProperty("user.dir"));
        UpdatePackages updater = new UpdatePackages(fBackup, fAdempiereHome, fUpdatePath);
        updater.backupAndMove(LIB);
        updater.backupAndMove(PACKAGES);
        updater.backupAndMove(ZKPACKAGES);
        System.exit(0);
    }
}

