/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cmdtools;

import com.f3p.adempiere.cmdtools.FileBasedPackIn;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import org.compiere.Adempiere;
import org.compiere.util.Env;

public class Batch2PackImport {
    protected FilenameFilter m_2packFilter = new ZipFileNameFilter();

    public Batch2PackImport() {
        new Adempiere();
        Adempiere.startup(true);
        Properties ctx = Env.getCtx();
        Env.setContext(ctx, "#AD_Client_ID", 0);
        Env.setContext(ctx, "#AD_Org_ID", 0);
        Env.setContext(ctx, "#AD_Role_ID", 0);
        Env.setContext(ctx, "#AD_User_ID", 100);
    }

    public void processFolder(File fFolder, File fDest) throws IOException {
        if (!(fDest.isDirectory() && fDest.exists() && fFolder.exists())) {
            throw new IOException("2Pack source or dest folders missing");
        }
        File[] fileArray = fFolder.listFiles(this.m_2packFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f2Pack = fileArray[n2];
            if (f2Pack.isFile()) {
                FileBasedPackIn f2PackProcess = new FileBasedPackIn(f2Pack, fDest);
                f2PackProcess.packin();
                if (!f2Pack.delete()) {
                    f2Pack.deleteOnExit();
                }
            }
            ++n2;
        }
    }

    public static void main(String[] args) throws IOException {
        File fSrcPath = new File(args[0]);
        File fOutPath = new File(args[1]);
        Batch2PackImport importer = new Batch2PackImport();
        importer.processFolder(fSrcPath, fOutPath);
        System.exit(0);
    }

    class ZipFileNameFilter
    implements FilenameFilter {
        ZipFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".zip");
        }
    }
}

