/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.cf.process.CFTaxPostProcess;
import com.f3p.adempiere.cf.process.CashFlowGenerator;
import com.f3p.commons.Utils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CashFlow
extends SvrProcess {
    protected static final String PARAM_CLIENT = "AD_Client_ID";
    protected static final String PARAM_ORG = "AD_Org_ID";
    protected static final String PARAM_CF_DEF = "F3P_CFlowDef_ID";
    protected static final String PARAM_DATEFROM = "Date";
    protected static final String PARAM_DATEFROM_ORD = "OrderDateFrom";
    protected static final String PARAM_ONLYCOMPL = "OnlyCompleted";
    protected static final String PARAM_OPENING_TAX_CREDIT = "OpenTaxCredit";
    protected static final String SQL_CF_DET = "SELECT * FROM F3P_CFLOWDEF_DET WHERE F3P_CFLOWDEF_ID =? AND ISACTIVE = 'Y' ORDER BY SEQNO";
    protected CFParams m_cfParams;
    protected int m_CFlowDef_ID = 0;

    @Override
    protected String doIt() throws Exception {
        CPreparedStatement pstmt = DB.prepareStatement(SQL_CF_DET, this.get_TrxName());
        ResultSet rs = null;
        try {
            pstmt.setInt(1, this.m_CFlowDef_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String sClassName = rs.getString("ClassName");
                try {
                    Class<?> classDef = Class.forName(sClassName);
                    CashFlowGenerator cfBuilder = (CashFlowGenerator)classDef.newInstance();
                    String sResult = cfBuilder.start(this.m_cfParams);
                    if (Utils.isEmptyString(sResult)) continue;
                    throw new AdempiereException(sResult);
                }
                catch (ClassNotFoundException e) {
                    this.log.log(Level.SEVERE, String.valueOf(Msg.getMsg(Env.getCtx(), "F3P_CF_ClassNotFound")) + sClassName + "\n", e);
                    throw new AdempiereException("@F3P_CF_ClassNotFound@" + sClassName);
                }
                catch (ClassCastException e) {
                    this.log.log(Level.SEVERE, "Class " + sClassName + Msg.getMsg(Env.getCtx(), "F3P_CF_ClassNotValid"), e);
                    throw new AdempiereException("@F3P_CF_ClassNotValid@" + sClassName);
                }
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        CFTaxPostProcess taxPostProc = new CFTaxPostProcess();
        String sResult = taxPostProc.start(this.m_cfParams);
        if (!Utils.isEmptyString(sResult)) {
            throw new AdempiereException(sResult);
        }
        return "";
    }

    @Override
    protected void prepare() {
        this.m_cfParams = new CFParams();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals(PARAM_CLIENT)) {
                    this.m_cfParams.setAD_Client_ID(((BigDecimal)para[i].getParameter()).intValue());
                } else if (name.equals(PARAM_ORG)) {
                    this.m_cfParams.setAD_Org_ID(((BigDecimal)para[i].getParameter()).intValue());
                } else if (name.equals(PARAM_CF_DEF)) {
                    this.m_CFlowDef_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals(PARAM_DATEFROM)) {
                    this.m_cfParams.setDateFrom((Timestamp)para[i].getParameter());
                    this.m_cfParams.setDateTo((Timestamp)para[i].getParameter_To());
                } else if (name.equals(PARAM_DATEFROM_ORD)) {
                    this.m_cfParams.setDateFromOrder((Timestamp)para[i].getParameter());
                } else if (name.equals(PARAM_ONLYCOMPL)) {
                    this.m_cfParams.setOnlyCompletedDocs(para[i].getParameter().equals("Y"));
                } else if (name.equals(PARAM_OPENING_TAX_CREDIT)) {
                    this.m_cfParams.setOpenTaxCredit((BigDecimal)para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_cfParams.set_TrxName(this.get_TrxName());
        this.m_cfParams.setAD_PInstance_ID(this.getAD_PInstance_ID());
    }
}

