/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.cf.process.CashFlowGenerator;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.commons.JDBCUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MConversionRate;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CF_TaxFromInvoice
implements CashFlowGenerator {
    @Override
    public String start(CFParams params) throws SQLException {
        StringBuffer sbErrors;
        block10: {
            sbErrors = new StringBuffer();
            String sSqlTaxDate = QueryRepo.getQuery("com/f3p/adempiere/cf/taxPayScheduleDate");
            String sSqlPayTax = QueryRepo.getQuery("com/f3p/adempiere/cf/taxPaySchedule");
            CPreparedStatement pstmtDate = null;
            CPreparedStatement pstmtTax = null;
            ResultSet rsDate = null;
            ResultSet rsTax = null;
            String sBoolOnlyCompl = null;
            sBoolOnlyCompl = params.isOnlyCompletedDocs() ? "Y" : "N";
            int contextCurrencyID = Integer.parseInt(Env.getCtx().getProperty("$C_Currency_ID"));
            try {
                try {
                    pstmtDate = DB.prepareStatement(sSqlTaxDate, params.get_TrxName());
                    pstmtDate.setTimestamp(1, params.getDateFrom());
                    pstmtDate.setTimestamp(2, params.getDateFrom());
                    pstmtDate.setTimestamp(3, params.getDateFrom());
                    pstmtDate.setTimestamp(4, params.getDateTo());
                    pstmtDate.setInt(5, params.getAD_Client_ID());
                    pstmtDate.setInt(6, params.getAD_Org_ID());
                    pstmtDate.setInt(7, params.getAD_Org_ID());
                    pstmtDate.setTimestamp(8, params.getDateTo());
                    pstmtDate.setTimestamp(9, params.getDateTo());
                    pstmtDate.setTimestamp(10, params.getDateFrom());
                    pstmtDate.setTimestamp(11, params.getDateTo());
                    pstmtDate.setTimestamp(12, params.getDateFrom());
                    pstmtDate.setTimestamp(13, params.getDateTo());
                    pstmtDate.setInt(14, params.getAD_Client_ID());
                    pstmtDate.setInt(15, params.getAD_Org_ID());
                    pstmtDate.setInt(16, params.getAD_Org_ID());
                    rsDate = pstmtDate.executeQuery();
                    while (rsDate.next()) {
                        Timestamp tsDataPayCalc = rsDate.getTimestamp("DATAPAYCALC");
                        Calendar calPay = Calendar.getInstance();
                        Calendar calDateFromRev = Calendar.getInstance();
                        Calendar calDateToRev = Calendar.getInstance();
                        calPay.setTimeInMillis(tsDataPayCalc.getTime());
                        String sTaxMonth = rsDate.getString("TAXMONTH");
                        String sPayDate = rsDate.getString("PAYDATE");
                        int nYearRif = calPay.get(1);
                        int nTaxMonth = Integer.parseInt(sTaxMonth.substring(0, sTaxMonth.length()));
                        int nPayDateMonth = Integer.parseInt(sPayDate.substring(2, 4));
                        if (nTaxMonth > nPayDateMonth) {
                            ++nYearRif;
                        }
                        calDateFromRev.set(2, nTaxMonth - 1);
                        calDateFromRev.set(5, 1);
                        calDateFromRev.set(1, nYearRif);
                        calDateToRev.set(2, nTaxMonth - 1);
                        calDateToRev.set(5, calDateToRev.getActualMaximum(5));
                        calDateToRev.set(1, nYearRif);
                        calDateFromRev.set(11, calDateFromRev.getActualMinimum(11));
                        calDateFromRev.set(12, calDateFromRev.getActualMinimum(12));
                        calDateToRev.set(11, calDateToRev.getActualMaximum(11));
                        calDateToRev.set(12, calDateToRev.getActualMaximum(12));
                        pstmtTax = DB.prepareStatement(sSqlPayTax, params.get_TrxName());
                        pstmtTax.setInt(1, params.getAD_Org_ID());
                        pstmtTax.setInt(2, params.getAD_Org_ID());
                        pstmtTax.setString(3, sBoolOnlyCompl);
                        pstmtTax.setString(4, sBoolOnlyCompl);
                        pstmtTax.setTimestamp(5, new Timestamp(calDateFromRev.getTimeInMillis()));
                        pstmtTax.setTimestamp(6, new Timestamp(calDateToRev.getTimeInMillis()));
                        rsTax = pstmtTax.executeQuery();
                        while (rsTax.next()) {
                            BigDecimal bdTaxAmount = rsTax.getBigDecimal("TAXAMT");
                            int invoiceCurrencyID = rsTax.getInt("C_CURRENCY_ID");
                            int C_ConversionType_ID = rsTax.getInt("C_CONVERSIONTYPE_ID");
                            boolean bIsSOTrx = rsTax.getString("IsSOTrx").equals("Y");
                            if (invoiceCurrencyID != contextCurrencyID) {
                                bdTaxAmount = MConversionRate.convert(Env.getCtx(), bdTaxAmount, invoiceCurrencyID, contextCurrencyID, tsDataPayCalc, C_ConversionType_ID, params.getAD_Client_ID(), params.getAD_Org_ID());
                            }
                            if (bIsSOTrx) {
                                bdTaxAmount = bdTaxAmount.negate();
                            }
                            MTF3PCashFlow CFLine = new MTF3PCashFlow(Env.getCtx(), 0, params.get_TrxName());
                            CFLine.setAD_PInstance_ID(params.getAD_PInstance_ID());
                            CFLine.setMovDate(tsDataPayCalc);
                            CFLine.setMovVal(bdTaxAmount);
                            CFLine.setREPVAL(bdTaxAmount);
                            CFLine.setMovType("T");
                            CFLine.setC_BPartner_ID(rsTax.getInt("C_BPARTNER_ID"));
                            CFLine.setDocumentNo(rsTax.getString("DOCUMENTNO"));
                            CFLine.setDocumentDate(rsTax.getTimestamp("DATEINVOICED"));
                            CFLine.setAD_Table_ID(IDResolver.getAD_Table_ID("C_Invoice"));
                            CFLine.setRecord_ID(rsTax.getInt("C_INVOICE_ID"));
                            CFLine.setDocStatus(rsTax.getString("DOCSTATUS"));
                            if (CFLine.save(params.get_TrxName())) continue;
                            sbErrors.append(Msg.getMsg(Env.getCtx(), "F3P_CF_ErrTaxDef"));
                        }
                        JDBCUtils.closeResults(pstmtTax, rsTax);
                    }
                }
                catch (NumberFormatException e) {
                    sbErrors.append(Msg.getMsg(Env.getCtx(), "F3P_CF_ErrDatePaymDef"));
                    JDBCUtils.closeResults(pstmtDate, rsDate);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.closeResults(pstmtDate, rsDate);
                throw throwable;
            }
            JDBCUtils.closeResults(pstmtDate, rsDate);
        }
        return sbErrors.toString();
    }
}

