/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.CashFlowUtils;
import com.f3p.adempiere.cf.model.MF3PCFTaxPaySched;
import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.cf.process.CashFlowGenerator;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.commons.JDBCUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CF_RecurrentPay
implements CashFlowGenerator {
    public static final String SQL_RECUR_PAY = "select * from F3P_CFRecurPayments where (0=? OR AD_Org_ID = ? ) and PERENDDATE >= ? and ISACTIVE = 'Y'";

    @Override
    public String start(CFParams params) throws SQLException {
        StringBuffer sbErrors = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(SQL_RECUR_PAY, params.get_TrxName());
            pstmt.setInt(1, params.getAD_Org_ID());
            pstmt.setInt(2, params.getAD_Org_ID());
            pstmt.setTimestamp(3, params.getDateFrom());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Timestamp tsStartDate = rs.getTimestamp("PERNEXTDATE");
                Timestamp tsEndDate = rs.getTimestamp("PERENDDATE");
                boolean bLastMonthDay = rs.getString("ISLASTMONTHDAY").equals("Y");
                String sUomPeriod = rs.getString("UOMPERIOD");
                int nNPeriod = rs.getInt("NPERIOD");
                Timestamp tsNextDate = tsStartDate;
                while (tsNextDate.compareTo(tsEndDate) <= 0 && tsNextDate.compareTo(params.getDateTo()) <= 0) {
                    BigDecimal bdGrandTotal = rs.getBigDecimal("GRANDTOTAL");
                    int C_BPartner_ID = rs.getInt("C_BPARTNER_ID");
                    int nRecordID = rs.getInt("F3P_CFRECURPAYMENTS_ID");
                    String sDescription = rs.getString("DESCRIPTION");
                    if (tsNextDate.compareTo(params.getDateFrom()) >= 0) {
                        MTF3PCashFlow CFLine = new MTF3PCashFlow(Env.getCtx(), 0, params.get_TrxName());
                        CFLine.setAD_PInstance_ID(params.getAD_PInstance_ID());
                        CFLine.setC_BPartner_ID(C_BPartner_ID);
                        CFLine.setRecord_ID(nRecordID);
                        CFLine.setMovDate(tsNextDate);
                        CFLine.setMovVal(bdGrandTotal.negate());
                        CFLine.setREPVAL(bdGrandTotal.negate());
                        CFLine.setMovType("S");
                        CFLine.setDescription(sDescription);
                        CFLine.setAD_Table_ID(IDResolver.getAD_Table_ID("F3P_CFRecurPayments"));
                        if (!CFLine.save(params.get_TrxName())) {
                            sbErrors.append(Msg.getMsg(Env.getCtx(), "F3P_CF_ErrPayDef"));
                        }
                    }
                    boolean bHasTax = rs.getString("HASTAX").equals("Y");
                    Timestamp tsTaxPayDate = MF3PCFTaxPaySched.getPayDate(tsNextDate, params);
                    if (bHasTax && tsTaxPayDate.compareTo(params.getDateFrom()) >= 0 && tsTaxPayDate.compareTo(params.getDateTo()) <= 0) {
                        BigDecimal bdPerAmount = rs.getBigDecimal("PERAMOUNT");
                        BigDecimal bdTaxAmount = bdGrandTotal.subtract(bdPerAmount);
                        MTF3PCashFlow CFTaxLine = new MTF3PCashFlow(Env.getCtx(), 0, params.get_TrxName());
                        CFTaxLine.setAD_PInstance_ID(params.getAD_PInstance_ID());
                        CFTaxLine.setC_BPartner_ID(C_BPartner_ID);
                        CFTaxLine.setRecord_ID(nRecordID);
                        CFTaxLine.setMovDate(tsTaxPayDate);
                        CFTaxLine.setMovVal(bdTaxAmount);
                        CFTaxLine.setREPVAL(bdTaxAmount);
                        CFTaxLine.setMovType("T");
                        CFTaxLine.setDescription(String.valueOf(Msg.getMsg(Env.getCtx(), "F3P_CF_TaxAbout")) + sDescription);
                        CFTaxLine.setAD_Table_ID(IDResolver.getAD_Table_ID("F3P_CFRecurPayments"));
                        if (!CFTaxLine.save(params.get_TrxName())) {
                            sbErrors.append(Msg.getMsg(Env.getCtx(), "F3P_CF_ErrPayDef"));
                        }
                    }
                    tsNextDate = CashFlowUtils.getNextDate(sUomPeriod, nNPeriod, tsNextDate, bLastMonthDay);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.closeResults(pstmt, rs);
            throw throwable;
        }
        JDBCUtils.closeResults(pstmt, rs);
        return sbErrors.toString();
    }
}

