/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFOrderHelper;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.commons.JDBCUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CF_Order {
    public static String start(CFParams params, boolean bIsSOTrx) throws SQLException {
        StringBuffer sbErrors = new StringBuffer();
        if (params.getDateFromOrder() == null) {
            return Msg.getMsg(Env.getCtx(), "F3P_CF_DateMandatory");
        }
        String sSql = QueryRepo.getQuery("com/f3p/adempiere/cf/order");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sIsSOTrx = "Y";
            String sIsOnlyCOmpletedDocs = "Y";
            if (!bIsSOTrx) {
                sIsSOTrx = "N";
            }
            if (!params.isOnlyCompletedDocs()) {
                sIsOnlyCOmpletedDocs = "N";
            }
            pstmt = DB.prepareStatement(sSql, params.get_TrxName());
            pstmt.setInt(1, params.getAD_Client_ID());
            pstmt.setInt(2, params.getAD_Org_ID());
            pstmt.setInt(3, params.getAD_Org_ID());
            pstmt.setString(4, sIsSOTrx);
            pstmt.setString(5, sIsOnlyCOmpletedDocs);
            pstmt.setString(6, sIsOnlyCOmpletedDocs);
            pstmt.setTimestamp(7, params.getDateFromOrder());
            pstmt.setTimestamp(8, params.getDateTo());
            rs = pstmt.executeQuery();
            CFOrderHelper orderHelper = new CFOrderHelper(params, bIsSOTrx);
            HashMap<String, LinkedList<MTF3PCashFlow>> hmCFLines = orderHelper.createLinesFromRs(rs);
            if (hmCFLines != null) {
                CF_Order.saveLines(hmCFLines, params.get_TrxName());
            } else {
                sbErrors.append(Msg.getMsg(Env.getCtx(), "F3P_CF_ErrOrdElab"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.closeResults(pstmt, rs);
            throw throwable;
        }
        JDBCUtils.closeResults(pstmt, rs);
        return sbErrors.toString();
    }

    public static void saveLines(HashMap<String, LinkedList<MTF3PCashFlow>> hmCFLines, String sTrxName) {
        LinkedList<MTF3PCashFlow> lsTaxLines = hmCFLines.get("taxLine");
        LinkedList<MTF3PCashFlow> lsOrderLines = hmCFLines.get("taxLine");
        for (MTF3PCashFlow line : lsTaxLines) {
            line.save(sTrxName);
        }
        for (MTF3PCashFlow line : lsOrderLines) {
            line.save(sTrxName);
        }
    }
}

