/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.commons.JDBCUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.model.MConversionRate;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CF_Invoice {
    public static String start(CFParams params, boolean isSOTrx) throws SQLException {
        StringBuffer sbErrors = new StringBuffer();
        boolean bExpiredNeedSave = false;
        BigDecimal bdTotalExpiredAMT = new BigDecimal(0);
        int C_Invoice_ID = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int contextCurrencyID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
            String sSql = QueryRepo.getQuery("com/f3p/adempiere/cf/invoice");
            pstmt = DB.prepareStatement(sSql, params.get_TrxName());
            pstmt.setInt(1, params.getAD_Client_ID());
            pstmt.setInt(2, params.getAD_Org_ID());
            pstmt.setInt(3, params.getAD_Org_ID());
            String sBoolean = "N";
            sBoolean = isSOTrx ? "Y" : "N";
            pstmt.setString(4, sBoolean);
            sBoolean = params.isOnlyCompletedDocs() ? "Y" : "N";
            pstmt.setString(5, sBoolean);
            pstmt.setString(6, sBoolean);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String sErr;
                C_Invoice_ID = rs.getInt("C_INVOICE_ID");
                Timestamp tsPaymentDate = rs.getTimestamp("PAYMENTDATE");
                BigDecimal bdOpenAMT = rs.getBigDecimal("OpenAMT");
                int invoiceCurrencyID = rs.getInt("C_CURRENCY_ID");
                int C_ConversionType_ID = rs.getInt("C_ConversionType_ID");
                if (!isSOTrx) {
                    bdOpenAMT = bdOpenAMT.negate();
                }
                if (invoiceCurrencyID != contextCurrencyID) {
                    bdOpenAMT = MConversionRate.convert(Env.getCtx(), bdOpenAMT, invoiceCurrencyID, contextCurrencyID, tsPaymentDate, C_ConversionType_ID, params.getAD_Client_ID(), params.getAD_Org_ID());
                }
                if (tsPaymentDate.compareTo(params.getDateFrom()) < 0) {
                    bExpiredNeedSave = true;
                    bdTotalExpiredAMT = bdTotalExpiredAMT.add(bdOpenAMT);
                    continue;
                }
                if (tsPaymentDate.compareTo(params.getDateTo()) > 0) {
                    if (bExpiredNeedSave) {
                        sErr = CF_Invoice.saveExpired(params, bdTotalExpiredAMT);
                        sbErrors.append(sErr);
                        bExpiredNeedSave = false;
                    }
                    break;
                }
                if (tsPaymentDate.compareTo(params.getDateFrom()) < 0) continue;
                if (bExpiredNeedSave) {
                    sErr = CF_Invoice.saveExpired(params, bdTotalExpiredAMT);
                    sbErrors.append(sErr);
                    bExpiredNeedSave = false;
                }
                MTF3PCashFlow cfLine = new MTF3PCashFlow(Env.getCtx(), 0, params.get_TrxName());
                cfLine.setAD_PInstance_ID(params.getAD_PInstance_ID());
                cfLine.setMovDate(tsPaymentDate);
                cfLine.setMovVal(bdOpenAMT);
                cfLine.setREPVAL(bdOpenAMT);
                cfLine.setMovType("I");
                cfLine.setC_BPartner_ID(rs.getInt("C_BPARTNER_ID"));
                cfLine.setDocumentNo(rs.getString("DOCUMENTNO"));
                cfLine.setDocumentDate(rs.getTimestamp("DATEINVOICED"));
                cfLine.setAD_Table_ID(IDResolver.getAD_Table_ID("C_Invoice"));
                cfLine.setRecord_ID(C_Invoice_ID);
                cfLine.setDocStatus(rs.getString("DOCSTATUS"));
                cfLine.save(params.get_TrxName());
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.closeResults(pstmt, rs);
            throw throwable;
        }
        JDBCUtils.closeResults(pstmt, rs);
        return sbErrors.toString();
    }

    protected static String saveExpired(CFParams params, BigDecimal bdExpiredAMT) {
        String sErrors = "";
        MTF3PCashFlow expired = new MTF3PCashFlow(Env.getCtx(), 0, params.get_TrxName());
        expired.setAD_PInstance_ID(params.getAD_PInstance_ID());
        expired.setMovDate(MTF3PCashFlow.dayBefore(params.getDateFrom()));
        expired.setMovType("I");
        expired.setMovVal(bdExpiredAMT);
        expired.setREPVAL(bdExpiredAMT);
        expired.setDescription(Msg.getMsg(Env.getCtx(), "F3P_CF_ExpiredPaym"));
        if (!expired.save(params.get_TrxName())) {
            sErrors = Msg.getMsg(Env.getCtx(), "F3P_CF_ErrExpPay");
        }
        return sErrors;
    }
}

