/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.cf.process.CashFlowGenerator;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.commons.JDBCUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CF_GenericTransaction
implements CashFlowGenerator {
    @Override
    public String start(CFParams params) throws SQLException {
        StringBuffer sbErrors = new StringBuffer();
        String sSql = QueryRepo.getQuery("com/f3p/adempiere/cf/genericTransaction");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sSql, params.get_TrxName());
            pstmt.setInt(1, params.getAD_Client_ID());
            pstmt.setInt(2, params.getAD_Org_ID());
            pstmt.setInt(3, params.getAD_Org_ID());
            pstmt.setTimestamp(4, params.getDateFrom());
            pstmt.setTimestamp(5, params.getDateTo());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MTF3PCashFlow CFLine = new MTF3PCashFlow(Env.getCtx(), 0, params.get_TrxName());
                BigDecimal bdTotal = rs.getBigDecimal("GrandTotal");
                if (rs.getString("IsSOTrx").equals("N")) {
                    bdTotal = bdTotal.negate();
                }
                CFLine.setAD_PInstance_ID(params.getAD_PInstance_ID());
                CFLine.setMovDate(rs.getTimestamp("DueDate"));
                CFLine.setMovVal(bdTotal);
                CFLine.setREPVAL(bdTotal);
                CFLine.setMovType("G");
                CFLine.setC_BPartner_ID(rs.getInt("C_BPartner_ID"));
                CFLine.setDocumentNo(rs.getString("DOCUMENTNO"));
                CFLine.setDocumentDate(rs.getTimestamp("DateTrx"));
                CFLine.setAD_Table_ID(IDResolver.getAD_Table_ID("C_CashFlow"));
                CFLine.setRecord_ID(rs.getInt("C_CashFlow_ID"));
                CFLine.setDescription(rs.getString("DESCRIPTION"));
                if (CFLine.save(params.get_TrxName())) continue;
                sbErrors.append(Msg.getMsg(Env.getCtx(), "F3P_CF_ErrGenTrans"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.closeResults(pstmt, rs);
            throw throwable;
        }
        JDBCUtils.closeResults(pstmt, rs);
        return sbErrors.toString();
    }
}

