/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.cf.process.CashFlowGenerator;
import java.math.BigDecimal;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CF_CurrentBalance
implements CashFlowGenerator {
    protected static final String SQL_CASH = "select SUM(C_BankAccount.CURRENTBALANCE) from C_BankAccount where C_BankAccount.IsActive = 'Y' and C_BankAccount.AD_Client_ID = ? and (?=0 OR C_BankAccount.AD_Org_ID = ?)";

    @Override
    public String start(CFParams params) {
        String sErrors = "";
        BigDecimal bdCurrentBalance = DB.getSQLValueBDEx(params.get_TrxName(), SQL_CASH, params.getAD_Client_ID(), params.getAD_Org_ID(), params.getAD_Org_ID());
        MTF3PCashFlow cfLine = new MTF3PCashFlow(Env.getCtx(), 0, params.get_TrxName());
        cfLine.setAD_PInstance_ID(params.getAD_PInstance_ID());
        cfLine.setMovDate(MTF3PCashFlow.dayBefore(params.getDateFrom()));
        cfLine.setMovVal(bdCurrentBalance);
        cfLine.setREPVAL(bdCurrentBalance);
        cfLine.setMovType("G");
        cfLine.setDescription(Msg.getMsg(Env.getCtx(), "F3P_CF_StartBalance"));
        if (!cfLine.save(params.get_TrxName())) {
            sErrors = Msg.getMsg(Env.getCtx(), "F3P_CF_ErStartBal");
        }
        return sErrors;
    }
}

