/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.cf.process.CashFlowGenerator;
import com.f3p.commons.JDBCUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CFTaxPostProcess
implements CashFlowGenerator {
    public static final String SQL_GET_TAXLINES = "select * from T_F3PCASHFLOW WHERE MOVTYPE = 'T' AND AD_PINSTANCE_ID = ? ORDER BY MOVDATE, movtype, MOVVAL DESC, documentdate, documentno, T_F3Pcashflow_id";

    @Override
    public String start(CFParams params) throws SQLException {
        StringBuffer sbErrors = new StringBuffer();
        BigDecimal bdTotal = params.getOpenTaxCredit();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(SQL_GET_TAXLINES, params.get_TrxName());
            pstmt.setInt(1, params.getAD_PInstance_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MTF3PCashFlow CFLine = new MTF3PCashFlow(Env.getCtx(), rs, params.get_TrxName());
                if ((bdTotal = bdTotal.add(CFLine.getREPVAL())).compareTo(BigDecimal.ZERO) < 0) {
                    CFLine.setREPVAL(bdTotal);
                    bdTotal = BigDecimal.ZERO;
                } else {
                    CFLine.setREPVAL(BigDecimal.ZERO);
                }
                CFLine.save(params.get_TrxName());
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.closeResults(pstmt, rs);
            throw throwable;
        }
        JDBCUtils.closeResults(pstmt, rs);
        return sbErrors.toString();
    }
}

