/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.process;

import com.f3p.adempiere.cf.CashFlowUtils;
import com.f3p.adempiere.cf.model.MF3PCFTaxPaySched;
import com.f3p.adempiere.cf.model.MTF3PCashFlow;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.PaymentScheduleHelper;
import com.f3p.commons.JDBCUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import org.compiere.model.MConversionRate;
import org.compiere.sqlj.PaymentTerm;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CFOrderHelper {
    private static CLogger s_log = CLogger.getCLogger(CFOrderHelper.class);
    public static final String TAX_LINE = "taxLine";
    public static final String ORDER_LINE = "orderLine";
    public static final String SQL_PAYMSCHED = "select * from C_PaySchedule where C_PAYMENTTERM_ID = ? and ISACTIVE = 'Y'";
    public static final String SQL_TAXRATE = "select RATE from C_TAX where C_TAX_ID = ?";
    protected boolean m_bIsSOTrx;
    protected CFParams m_CFParams;
    protected int m_AD_Org_ID;
    protected int m_AD_Client_ID;
    protected int m_nContextCurrencyID;
    protected LinkedList<MTF3PCashFlow> m_lstOrderLines = new LinkedList();
    protected LinkedList<MTF3PCashFlow> m_lstTaxLines = new LinkedList();
    protected HashMap<String, LinkedList<MTF3PCashFlow>> m_hmCashFlowOrderLines = new HashMap();

    public CFOrderHelper(CFParams params, boolean bIsSOTrx) {
        this.m_CFParams = params;
        this.m_bIsSOTrx = bIsSOTrx;
        this.m_AD_Org_ID = params.getAD_Org_ID();
        this.m_AD_Client_ID = params.getAD_Client_ID();
        this.m_hmCashFlowOrderLines.put(TAX_LINE, this.m_lstOrderLines);
        this.m_hmCashFlowOrderLines.put(ORDER_LINE, this.m_lstTaxLines);
        this.m_nContextCurrencyID = Integer.parseInt(Env.getCtx().getProperty("$C_Currency_ID"));
    }

    public HashMap<String, LinkedList<MTF3PCashFlow>> createLinesFromRs(ResultSet rs) {
        CPreparedStatement pstmtSched = null;
        ResultSet rsSched = null;
        try {
            try {
                while (rs.next()) {
                    int C_PaymentTerm_ID = rs.getInt("C_PAYMENTTERM_ID");
                    BigDecimal bdAmount = rs.getBigDecimal("AMOUNT");
                    Timestamp tsDateRif = rs.getTimestamp("DateRif");
                    Timestamp tsDataPayCalc = null;
                    pstmtSched = DB.prepareStatement(SQL_PAYMSCHED, this.m_CFParams.get_TrxName());
                    pstmtSched.setInt(1, C_PaymentTerm_ID);
                    rsSched = pstmtSched.executeQuery();
                    boolean bExistSched = false;
                    while (rsSched.next()) {
                        bExistSched = true;
                        PaymentScheduleHelper.Instalment[] instalments = PaymentScheduleHelper.calculatePaymentSchedule(C_PaymentTerm_ID, bdAmount, tsDateRif, this.m_CFParams.get_TrxName());
                        int i = 0;
                        while (i < instalments.length) {
                            PaymentScheduleHelper.Instalment payInst = instalments[i];
                            this.insertInstalment(payInst, rs);
                            this.insertTax(tsDateRif, rs);
                            ++i;
                        }
                    }
                    if (bExistSched) continue;
                    CPreparedStatement pstmtDueDate = DB.prepareStatement("SELECT * FROM C_PaymentTerm WHERE C_PaymentTerm_ID=?", this.m_CFParams.get_TrxName());
                    tsDataPayCalc = PaymentTerm.dueDate(C_PaymentTerm_ID, tsDateRif, pstmtDueDate);
                    PaymentScheduleHelper.Instalment payInst = new PaymentScheduleHelper.Instalment(tsDataPayCalc, bdAmount);
                    this.insertInstalment(payInst, rs);
                    this.insertTax(tsDateRif, rs);
                }
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, Msg.getMsg(Env.getCtx(), "F3P_CF_ErrSQL"), e);
                this.m_hmCashFlowOrderLines = null;
                JDBCUtils.closeResults(pstmtSched, rsSched);
            }
        }
        finally {
            JDBCUtils.closeResults(pstmtSched, rsSched);
        }
        return this.m_hmCashFlowOrderLines;
    }

    protected MTF3PCashFlow insertInstalment(PaymentScheduleHelper.Instalment instalment, ResultSet rs) throws SQLException {
        MTF3PCashFlow CFLine = new MTF3PCashFlow(Env.getCtx(), 0, this.m_CFParams.get_TrxName());
        int currencyID = 0;
        int C_ConversionType_ID = 0;
        currencyID = rs.getInt("C_CURRENCY_ID");
        C_ConversionType_ID = rs.getInt("C_ConversionType_ID");
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = Integer.parseInt(Env.getCtx().getProperty("#C_ConversionType_ID"));
        }
        if (currencyID != this.m_nContextCurrencyID) {
            instalment.setTotal(MConversionRate.convert(Env.getCtx(), instalment.getTotal(), currencyID, this.m_nContextCurrencyID, instalment.getDueDate(), C_ConversionType_ID, this.m_AD_Client_ID, this.m_AD_Org_ID));
        }
        if (instalment.getDueDate().compareTo(this.m_CFParams.getDateFrom()) >= 0 && instalment.getDueDate().compareTo(this.m_CFParams.getDateTo()) <= 0) {
            BigDecimal bdAmount = instalment.getTotal();
            if (!this.m_bIsSOTrx) {
                bdAmount = bdAmount.negate();
            }
            bdAmount = CashFlowUtils.calculateGrandTotal(rs.getBigDecimal("RATE"), bdAmount, this.m_CFParams.get_TrxName());
            CFLine.setAD_PInstance_ID(this.m_CFParams.getAD_PInstance_ID());
            CFLine.setMovDate(instalment.getDueDate());
            CFLine.setMovVal(bdAmount.setScale(2, RoundingMode.HALF_UP));
            CFLine.setREPVAL(bdAmount.setScale(2, RoundingMode.HALF_UP));
            CFLine.setMovType("O");
            CFLine.setC_BPartner_ID(rs.getInt("C_BPARTNER_ID"));
            CFLine.setDocumentNo(rs.getString("DOCUMENTNO"));
            CFLine.setDocumentDate(rs.getTimestamp("DATEORDERED"));
            CFLine.setAD_Table_ID(IDResolver.getAD_Table_ID("C_Order"));
            CFLine.setRecord_ID(rs.getInt("RECORD_ID"));
            CFLine.setDocStatus(rs.getString("DOCSTATUS"));
            this.m_lstOrderLines.add(CFLine);
        }
        return CFLine;
    }

    protected MTF3PCashFlow insertTax(Timestamp tsDateRif, ResultSet rsParent) throws SQLException {
        MTF3PCashFlow CFLine = new MTF3PCashFlow(Env.getCtx(), 0, this.m_CFParams.get_TrxName());
        try {
            Timestamp tsDate = MF3PCFTaxPaySched.getPayDate(tsDateRif, this.m_CFParams);
            if (tsDate.compareTo(this.m_CFParams.getDateFrom()) >= 0 && tsDate.compareTo(this.m_CFParams.getDateTo()) <= 0) {
                int C_Tax_ID = Integer.parseInt(Env.getCtx().getProperty("#C_Tax_ID"));
                BigDecimal bdTaxRate = DB.getSQLValueBD(this.m_CFParams.get_TrxName(), SQL_TAXRATE, C_Tax_ID);
                BigDecimal bdAmount = rsParent.getBigDecimal("AMOUNT");
                bdAmount = bdAmount.multiply(bdTaxRate).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                if (this.m_bIsSOTrx) {
                    bdAmount = bdAmount.negate();
                }
                int currencyID = rsParent.getInt("C_CURRENCY_ID");
                int C_ConversionType_ID = rsParent.getInt("C_ConversionType_ID");
                int contextCurrencyID = Integer.parseInt(Env.getCtx().getProperty("$C_Currency_ID"));
                if (currencyID != contextCurrencyID) {
                    bdAmount = MConversionRate.convert(Env.getCtx(), bdAmount, currencyID, contextCurrencyID, tsDate, C_ConversionType_ID, this.m_AD_Client_ID, this.m_AD_Org_ID);
                }
                CFLine.setAD_PInstance_ID(this.m_CFParams.getAD_PInstance_ID());
                CFLine.setMovDate(tsDate);
                CFLine.setMovVal(bdAmount.setScale(2, RoundingMode.HALF_UP));
                CFLine.setREPVAL(bdAmount.setScale(2, RoundingMode.HALF_UP));
                CFLine.setMovType("T");
                CFLine.setC_BPartner_ID(rsParent.getInt("C_BPartner_ID"));
                CFLine.setDocumentNo(rsParent.getString("DOCUMENTNO"));
                CFLine.setDocumentDate(rsParent.getTimestamp("DATEORDERED"));
                CFLine.setAD_Table_ID(IDResolver.getAD_Table_ID("C_Order"));
                CFLine.setRecord_ID(rsParent.getInt("RECORD_ID"));
                CFLine.setDocStatus(rsParent.getString("DOCSTATUS"));
                this.m_lstTaxLines.add(CFLine);
            }
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, Msg.getMsg(Env.getCtx(), "F3P_CF_ErrDatePaymDef"), e);
        }
        return CFLine;
    }
}

