/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf.model;

import com.f3p.adempiere.cf.model.X_F3P_CFTaxPaySched;
import com.f3p.adempiere.cf.process.CFParams;
import com.f3p.commons.JDBCUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MF3PCFTaxPaySched
extends X_F3P_CFTaxPaySched {
    private static final long serialVersionUID = 1L;
    private static CLogger s_log = CLogger.getCLogger(MF3PCFTaxPaySched.class);
    public static final String SQL_TAX = "select TAXMONTH, PAYDATE from F3P_CFTaxPaySched where TaxMonth = TO_CHAR(?,'MM') and AD_Client_ID = ? and (0=? OR AD_Org_ID = ?) and isactive ='Y'";

    public MF3PCFTaxPaySched(Properties ctx, int F3P_CFTaxPaySched_ID, String trxName) {
        super(ctx, F3P_CFTaxPaySched_ID, trxName);
    }

    public MF3PCFTaxPaySched(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static Timestamp getPayDate(Timestamp tsDateRif, CFParams params) {
        Timestamp tsPayDate;
        block9: {
            tsPayDate = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    Calendar cal;
                    pstmt = DB.prepareStatement(SQL_TAX, params.get_TrxName());
                    pstmt.setTimestamp(1, tsDateRif);
                    pstmt.setInt(2, params.getAD_Client_ID());
                    pstmt.setInt(3, params.getAD_Org_ID());
                    pstmt.setInt(4, params.getAD_Org_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String sTaxMonth = rs.getString("TAXMONTH");
                        String sPayDate = rs.getString("PAYDATE");
                        int nPayDateDay = Integer.parseInt(sPayDate.substring(0, 2));
                        int nPayDateMonth = Integer.parseInt(sPayDate.substring(2, 4));
                        int nTaxMonth = Integer.parseInt(sTaxMonth.substring(0, sTaxMonth.length()));
                        Calendar calRif = Calendar.getInstance();
                        calRif.setTimeInMillis(tsDateRif.getTime());
                        cal = Calendar.getInstance();
                        cal.set(5, nPayDateDay);
                        cal.set(2, nPayDateMonth - 1);
                        if (nTaxMonth <= nPayDateMonth) {
                            cal.set(1, calRif.get(1));
                        } else {
                            cal.set(1, calRif.get(1) + 1);
                        }
                    } else {
                        throw new AdempiereException("@F3P_CF_ErrTaxNotExist@");
                    }
                    tsPayDate = new Timestamp(cal.getTimeInMillis());
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, Msg.getMsg(Env.getCtx(), "F3P_CF_ErrSQL"), e);
                    JDBCUtils.closeResults(pstmt, rs);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.closeResults(pstmt, rs);
                throw throwable;
            }
            JDBCUtils.closeResults(pstmt, rs);
        }
        return tsPayDate;
    }
}

