/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.cf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class CashFlowUtils {
    public static final String UOMPERIOD_Days = "G";
    public static final String UOMPERIOD_Months = "M";
    public static final String UOMPERIOD_Years = "A";
    public static final String SQL_TAX_RATE = "select RATE from C_TAX where C_TAX_ID = ? AND ISACTIVE = 'Y'";

    public static int getDelta(Timestamp perEndDate, Timestamp perNextDate, String sUOMPeriod, boolean bLastMonthDay) {
        int nDelta = 0;
        Calendar calEndDate = Calendar.getInstance();
        calEndDate.setTimeInMillis(perEndDate.getTime());
        Calendar calNextDate = Calendar.getInstance();
        calNextDate.setTimeInMillis(perNextDate.getTime());
        int endYear = calEndDate.get(1);
        int nextYear = calNextDate.get(1);
        int endMonth = calEndDate.get(2);
        int nextMonth = calNextDate.get(2);
        int endDay = calEndDate.get(5);
        int nextDay = calNextDate.get(5);
        if (calEndDate.equals(calNextDate)) {
            nDelta = 0;
        } else if (sUOMPeriod.equals(UOMPERIOD_Days)) {
            nDelta = TimeUtil.getDaysBetween(perNextDate, perEndDate);
        } else if (sUOMPeriod.equals(UOMPERIOD_Months)) {
            if (bLastMonthDay) {
                int nMonthMoltiplier = 12;
                nDelta = (endYear - nextYear) * nMonthMoltiplier;
                nDelta += endMonth - nextMonth;
                int nextMaxDay = calEndDate.getActualMaximum(5);
                if (endDay < nextDay && (!bLastMonthDay || bLastMonthDay && endDay != nextMaxDay)) {
                    --nDelta;
                }
            } else {
                int nStartDay = calNextDate.get(5);
                while (calNextDate.before(calEndDate) || calNextDate.equals(calEndDate)) {
                    calNextDate.add(2, 1);
                    calNextDate.set(5, nStartDay);
                    nStartDay = calNextDate.get(5);
                    ++nDelta;
                }
                --nDelta;
            }
        } else if (sUOMPeriod.equals(UOMPERIOD_Years)) {
            nDelta = endYear - nextYear;
            if (endMonth < nextMonth) {
                --nDelta;
            } else if (endMonth == nextMonth) {
                int nextMaxDay = calEndDate.getActualMaximum(5);
                if (endDay < nextDay && (!bLastMonthDay || bLastMonthDay && endDay != nextMaxDay)) {
                    --nDelta;
                }
            }
        }
        return nDelta;
    }

    public static Timestamp getNextDate(String sUomPeriod, int nNPeriod, Timestamp tsStartDate, boolean bLastMonthDay) {
        int fieldAdd = -1;
        int nLastDay = -1;
        int actualDay = -1;
        if (sUomPeriod.equals(UOMPERIOD_Days)) {
            fieldAdd = 5;
        } else if (sUomPeriod.equals(UOMPERIOD_Months)) {
            fieldAdd = 2;
        } else if (sUomPeriod.equals(UOMPERIOD_Years)) {
            fieldAdd = 1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(tsStartDate.getTime());
        if (fieldAdd != 5) {
            actualDay = cal.get(5);
            cal.set(5, 1);
        }
        cal.add(fieldAdd, nNPeriod);
        if (bLastMonthDay && fieldAdd != 5) {
            nLastDay = cal.getActualMaximum(5);
            cal.set(5, nLastDay);
        } else if (fieldAdd != 5 && (nLastDay = cal.getActualMaximum(5)) >= actualDay) {
            cal.set(5, actualDay);
        }
        return new Timestamp(cal.getTimeInMillis());
    }

    public static BigDecimal calculateTaxAmount(int C_Tax_ID, BigDecimal bdAmount, String sTrxName) {
        BigDecimal nTaxRate = DB.getSQLValueBD(sTrxName, SQL_TAX_RATE, C_Tax_ID);
        return bdAmount.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP).multiply(nTaxRate);
    }

    public static BigDecimal calculateGrandTotal(int C_Tax_ID, BigDecimal bdAmount, String sTrxName) {
        BigDecimal nTaxRate = DB.getSQLValueBD(sTrxName, SQL_TAX_RATE, C_Tax_ID);
        nTaxRate = nTaxRate.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP).add(BigDecimal.ONE);
        return bdAmount.multiply(nTaxRate);
    }

    public static BigDecimal calculateGrandTotal(BigDecimal bdTaxRate, BigDecimal bdAmount, String sTrxName) {
        bdTaxRate = bdTaxRate.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP).add(BigDecimal.ONE);
        return bdAmount.multiply(bdTaxRate);
    }
}

