/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.apps;

import com.f3p.commons.FileStreamUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.compiere.utils.DigestOfFile;

public class GenerateMD5Hashes {
    protected String[] m_sExt;
    protected File m_fPath;

    public static void main(String[] args) throws IOException {
        File fPath;
        if (args.length == 0) {
            GenerateMD5Hashes.printUsage();
            System.exit(1);
        }
        if (!(fPath = new File(args[0])).exists()) {
            throw new IOException("Invalid path " + args[0]);
        }
        String[] sWildcards = null;
        if (args.length > 1) {
            sWildcards = Arrays.copyOfRange(args, 1, args.length);
        }
        GenerateMD5Hashes generator = new GenerateMD5Hashes(fPath, sWildcards);
        generator.generate();
    }

    public static void printUsage() {
        System.out.println("GenerateMD5Hashes generate file md5 for files in specified path, subfolder included");
        System.out.println("Usage: generateMD5Hashes <path> <extension> <extension>");
        System.out.println("Note: if no pattern is specified, all files will be hashed");
        System.out.println("Example: generateMD5Hashes c:/report .jasper .jrxml");
    }

    public GenerateMD5Hashes(File fPath, String[] sExt) {
        this.m_sExt = sExt;
        this.m_fPath = fPath;
    }

    public void generate() throws IOException {
        this.recursiveGenerate(this.m_fPath);
        System.out.println("Complete.");
    }

    protected void recursiveGenerate(File fRoot) throws IOException {
        System.out.println("Generating for path: " + fRoot.toString());
        File[] fChilds = fRoot.listFiles();
        ArrayList<File> arDirectories = new ArrayList<File>();
        File[] fileArray = fChilds;
        int n = fChilds.length;
        int n2 = 0;
        while (n2 < n) {
            File fChild = fileArray[n2];
            if (fChild.isDirectory()) {
                arDirectories.add(fChild);
            } else if (fChild.isFile() && this.accept(fChild)) {
                System.out.println("Writing MD5 for " + fChild.getName());
                this.writeMD5(fChild);
            }
            ++n2;
        }
        for (File fDir : arDirectories) {
            this.recursiveGenerate(fDir);
        }
    }

    protected boolean accept(File file) {
        if (this.m_sExt == null) {
            return true;
        }
        String sName = file.getName();
        String[] stringArray = this.m_sExt;
        int n = this.m_sExt.length;
        int n2 = 0;
        while (n2 < n) {
            String sExt = stringArray[n2];
            if (sName.endsWith(sExt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void writeMD5(File fFile) throws IOException {
        String sMD5 = DigestOfFile.GetLocalMD5Hash(fFile);
        File fMD5 = new File(String.valueOf(fFile.getAbsolutePath()) + ".md5");
        FileWriter writer = null;
        try {
            writer = new FileWriter(fMD5);
            writer.write(sMD5);
            writer.flush();
        }
        catch (Throwable throwable) {
            FileStreamUtils.closeStream(writer);
            throw throwable;
        }
        FileStreamUtils.closeStream(writer);
    }
}

