/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.acct;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.util.ModelFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_C_AllocationHdr;
import org.compiere.model.I_C_Payment;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_C_AllocationLine;

public class PaymentAndAllocationClearingValidator
extends AbstractBoostrappableValidator
implements FactsValidator {
    public static final String F3P_ACCT_NO_CLEARINGS_PAYMENTALLOCATION = "POST_PAYMENT_CLEARING";

    @Override
    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO model) {
        if (MSysConfig.getBooleanValue(F3P_ACCT_NO_CLEARINGS_PAYMENTALLOCATION, false, model.getAD_Client_ID(), model.getAD_Org_ID())) {
            if (model instanceof I_C_Payment) {
                if (this.isNonPrepaidNorCharge(model)) {
                    facts.clear();
                }
            } else if (model instanceof I_C_AllocationHdr) {
                HashMap<Integer, FactLine> mapPaymentToFactLine = new HashMap<Integer, FactLine>();
                for (Fact fact : facts) {
                    ArrayList<FactLine> lstFactsToRemove = new ArrayList<FactLine>();
                    FactLine[] factLineArray = fact.getLines();
                    int n = factLineArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MPayment mPayment;
                        FactLine fLine = factLineArray[n2];
                        MAllocationLine mAllocLine = ModelFactory.getAllocationLine(model.getCtx(), fLine.getLine_ID(), model.get_TrxName());
                        if (mAllocLine.getC_Payment_ID() > 0 && this.isNonPrepaidNorCharge(mPayment = ModelFactory.getPayment(model.getCtx(), mAllocLine.getC_Payment_ID(), model.get_TrxName()))) {
                            Doc doc = model.getDoc();
                            int iBackupC_BankAccount_ID = doc.getC_BankAccount_ID();
                            doc.setC_BankAccount_ID(mPayment.getC_BankAccount_ID());
                            MAccount mAcctUnallocCash = doc.getAccount(10, schema);
                            MAccount mAcctPaySelect = doc.getAccount(12, schema);
                            MAccount mAcctInTransit = doc.getAccount(11, schema);
                            doc.setC_BankAccount_ID(iBackupC_BankAccount_ID);
                            if (fLine.getAccount().equals(mAcctUnallocCash) || fLine.getAccount().equals(mAcctPaySelect)) {
                                if (mapPaymentToFactLine.containsKey(mPayment.getC_Payment_ID())) {
                                    FactLine fPaymentLine = (FactLine)mapPaymentToFactLine.get(mPayment.getC_Payment_ID());
                                    BigDecimal bdAmtAcctCr = fPaymentLine.getAmtAcctCr();
                                    BigDecimal bdAmtAcctDr = fPaymentLine.getAmtAcctDr();
                                    BigDecimal bdAmtSourceCr = fPaymentLine.getAmtSourceCr();
                                    BigDecimal bdAmtSourceDr = fPaymentLine.getAmtSourceDr();
                                    bdAmtAcctCr = bdAmtAcctCr.add(fLine.getAmtAcctCr());
                                    bdAmtAcctDr = bdAmtAcctDr.add(fLine.getAmtAcctDr());
                                    bdAmtSourceCr = bdAmtSourceCr.add(fLine.getAmtSourceCr());
                                    bdAmtSourceDr = bdAmtSourceDr.add(fLine.getAmtSourceDr());
                                    fPaymentLine.setAmtAcct(bdAmtAcctDr, bdAmtAcctCr);
                                    fPaymentLine.setAmtSourceCr(bdAmtSourceCr);
                                    fPaymentLine.setAmtSourceDr(bdAmtSourceDr);
                                    lstFactsToRemove.add(fLine);
                                } else {
                                    fLine.setAccount(schema, mAcctInTransit);
                                    fLine.setLine_ID(-1);
                                    mapPaymentToFactLine.put(mPayment.getC_Payment_ID(), fLine);
                                }
                            }
                        }
                        ++n2;
                    }
                    for (FactLine flRemoved : lstFactsToRemove) {
                        fact.remove(flRemoved);
                    }
                }
            }
        }
        return null;
    }

    protected boolean isNonPrepaidNorCharge(PO model) {
        I_C_Payment mPayment = null;
        if (model instanceof I_C_Payment) {
            mPayment = (I_C_Payment)((Object)model);
        } else if (model instanceof X_C_AllocationLine) {
            mPayment = ((X_C_AllocationLine)model).getC_Payment();
        }
        if (mPayment == null) {
            throw new RuntimeException("Unsupported Class: " + model.getClass().getName());
        }
        return !mPayment.isPrepayment() && mPayment.getC_Charge_ID() <= 0;
    }

    @Override
    public String docValidate(PO model, int timing) {
        return null;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        super.initialize(engine, mClient);
        this.addFactsValidate(engine, "C_Payment");
        this.addFactsValidate(engine, "C_AllocationHdr");
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int timing) throws Exception {
        return null;
    }
}

