/*
 * Decompiled with CFR 0.152.
 */
package com.ancientprogramming.fixedformat4j.format.impl;

import com.ancientprogramming.fixedformat4j.annotation.Field;
import com.ancientprogramming.fixedformat4j.annotation.Fields;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatBoolean;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatDecimal;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatNumber;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatPattern;
import com.ancientprogramming.fixedformat4j.annotation.Record;
import com.ancientprogramming.fixedformat4j.exception.FixedFormatException;
import com.ancientprogramming.fixedformat4j.format.FixedFormatManager;
import com.ancientprogramming.fixedformat4j.format.FixedFormatUtil;
import com.ancientprogramming.fixedformat4j.format.FixedFormatter;
import com.ancientprogramming.fixedformat4j.format.FormatContext;
import com.ancientprogramming.fixedformat4j.format.FormatInstructions;
import com.ancientprogramming.fixedformat4j.format.ParseException;
import com.ancientprogramming.fixedformat4j.format.data.FixedFormatBooleanData;
import com.ancientprogramming.fixedformat4j.format.data.FixedFormatDecimalData;
import com.ancientprogramming.fixedformat4j.format.data.FixedFormatNumberData;
import com.ancientprogramming.fixedformat4j.format.data.FixedFormatPatternData;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedFormatManagerImpl
implements FixedFormatManager {
    private static final Log LOG = LogFactory.getLog(FixedFormatManagerImpl.class);

    @Override
    public <T> T load(Class<T> fixedFormatRecordClass, String data) {
        Method[] allMethods;
        T instance;
        HashMap<String, Object> foundData = new HashMap<String, Object>();
        HashMap methodClass = new HashMap();
        this.getAndAssertRecordAnnotation(fixedFormatRecordClass);
        try {
            Constructor<T> constructor = fixedFormatRecordClass.getDeclaredConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Class<?> declaringClass = fixedFormatRecordClass.getDeclaringClass();
            if (declaringClass != null) {
                try {
                    Object declaringClassInstance = null;
                    try {
                        Constructor<?> declaringClassConstructor = declaringClass.getDeclaredConstructor(new Class[0]);
                        declaringClassInstance = declaringClassConstructor.newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException dex) {
                        throw new FixedFormatException(String.format("Trying to create instance of innerclass %s, but the declaring class %s is missing a default constructor which is nessesary to be loaded through %s", fixedFormatRecordClass.getName(), declaringClass.getName(), this.getClass().getName()));
                    }
                    catch (Exception de) {
                        throw new FixedFormatException(String.format("unable to create instance of declaring class %s, which is needed to instansiate %s", declaringClass.getName(), fixedFormatRecordClass.getName()), e);
                    }
                    Constructor<T> constructor = fixedFormatRecordClass.getDeclaredConstructor(declaringClass);
                    instance = constructor.newInstance(declaringClassInstance);
                }
                catch (FixedFormatException ex) {
                    throw ex;
                }
                catch (NoSuchMethodException ex) {
                    throw new FixedFormatException(String.format("%s is missing a default constructor which is nessesary to be loaded through %s", fixedFormatRecordClass.getName(), this.getClass().getName()));
                }
                catch (Exception ex) {
                    throw new FixedFormatException(String.format("unable to create instance of %s", fixedFormatRecordClass.getName()), e);
                }
            }
            throw new FixedFormatException(String.format("%s is missing a default constructor which is nessesary to be loaded through %s", fixedFormatRecordClass.getName(), this.getClass().getName()));
        }
        catch (Exception e) {
            throw new FixedFormatException(String.format("unable to create instance of %s", fixedFormatRecordClass.getName()), e);
        }
        for (Method method : allMethods = fixedFormatRecordClass.getMethods()) {
            Object loadedData;
            String methodName = this.stripMethodPrefix(method.getName());
            Field fieldAnnotation = method.getAnnotation(Field.class);
            Fields fieldsAnnotation = method.getAnnotation(Fields.class);
            if (fieldAnnotation != null) {
                loadedData = this.readDataAccordingFieldAnnotation(fixedFormatRecordClass, data, method, fieldAnnotation);
                foundData.put(methodName, loadedData);
                methodClass.put(methodName, method.getReturnType());
                continue;
            }
            if (fieldsAnnotation == null) continue;
            if (fieldsAnnotation.value() == null || fieldsAnnotation.value().length == 0) {
                throw new FixedFormatException(String.format("%s annotation must contain minimum one %s annotation", Fields.class.getName(), Field.class.getName()));
            }
            loadedData = this.readDataAccordingFieldAnnotation(fixedFormatRecordClass, data, method, fieldsAnnotation.value()[0]);
            foundData.put(methodName, loadedData);
            methodClass.put(methodName, method.getReturnType());
        }
        Set keys = foundData.keySet();
        for (String key : keys) {
            Method method;
            String setterMethodName = "set" + key;
            Object foundDataObj = foundData.get(key);
            if (foundDataObj == null) continue;
            Class datatype = (Class)methodClass.get(key);
            try {
                method = fixedFormatRecordClass.getMethod(setterMethodName, datatype);
            }
            catch (NoSuchMethodException e) {
                throw new FixedFormatException(String.format("setter method named %s.%s(%s) does not exist", fixedFormatRecordClass.getName(), setterMethodName, datatype));
            }
            try {
                method.invoke(instance, foundData.get(key));
            }
            catch (Exception e) {
                throw new FixedFormatException(String.format("could not invoke method %s.%s(%s)", fixedFormatRecordClass.getName(), setterMethodName, datatype), e);
            }
        }
        return instance;
    }

    @Override
    public <T> String export(String existingData, T fixedFormatRecord) {
        Method[] allMethods;
        StringBuffer result = new StringBuffer(existingData);
        Record record = this.getAndAssertRecordAnnotation(fixedFormatRecord.getClass());
        Class<?> fixedFormatRecordClass = fixedFormatRecord.getClass();
        HashMap<Integer, String> foundData = new HashMap<Integer, String>();
        for (Method method : allMethods = fixedFormatRecordClass.getMethods()) {
            Field[] fields;
            Field fieldAnnotation = method.getAnnotation(Field.class);
            Fields fieldsAnnotation = method.getAnnotation(Fields.class);
            if (fieldAnnotation != null) {
                String exportedData = this.exportDataAccordingFieldAnnotation(fixedFormatRecord, method, fieldAnnotation);
                foundData.put(fieldAnnotation.offset(), exportedData);
                continue;
            }
            if (fieldsAnnotation == null) continue;
            for (Field field : fields = fieldsAnnotation.value()) {
                String exportedData = this.exportDataAccordingFieldAnnotation(fixedFormatRecord, method, field);
                foundData.put(field.offset(), exportedData);
            }
        }
        Set sortedoffsets = foundData.keySet();
        for (Integer offset : sortedoffsets) {
            String data = (String)foundData.get(offset);
            this.appendData(result, Character.valueOf(record.paddingChar()), offset, data);
        }
        if (record.length() != -1) {
            while (result.length() < record.length()) {
                result.append(record.paddingChar());
            }
        }
        return result.toString();
    }

    @Override
    public <T> String export(T fixedFormatRecord) {
        return this.export("", fixedFormatRecord);
    }

    private void appendData(StringBuffer result, Character paddingChar, Integer offset, String data) {
        int zeroBasedOffset = offset - 1;
        while (result.length() < zeroBasedOffset) {
            result.append(paddingChar);
        }
        int length = data.length();
        if (result.length() < zeroBasedOffset + length) {
            result.append(StringUtils.leftPad("", zeroBasedOffset + length - result.length(), paddingChar.charValue()));
        }
        result.replace(zeroBasedOffset, zeroBasedOffset + length, data);
    }

    private <T> Record getAndAssertRecordAnnotation(Class<T> fixedFormatRecordClass) {
        Record recordAnno = fixedFormatRecordClass.getAnnotation(Record.class);
        if (recordAnno == null) {
            throw new FixedFormatException(String.format("%s has to be marked with the record annotation to be loaded", fixedFormatRecordClass.getName()));
        }
        return recordAnno;
    }

    private <T> Object readDataAccordingFieldAnnotation(Class<T> clazz, String data, Method method, Field fieldAnno) throws ParseException {
        Object loadedData;
        Class datatype = this.getDatatype(method, fieldAnno);
        FormatContext context = this.getFormatContext(datatype, fieldAnno);
        FixedFormatter formatter = FixedFormatUtil.getFixedFormatterInstance(context.getFormatter(), context);
        FormatInstructions formatdata = this.getFormatInstructions(method, fieldAnno);
        String dataToParse = FixedFormatUtil.fetchData(data, formatdata, context);
        try {
            loadedData = formatter.parse(dataToParse, formatdata);
        }
        catch (RuntimeException e) {
            throw new ParseException(data, dataToParse, clazz, method, context, formatdata, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("the loaded data[" + loadedData + "]"));
        }
        return loadedData;
    }

    private Class getDatatype(Method method, Field fieldAnno) {
        if (!this.followsBeanStandard(method)) {
            throw new FixedFormatException(String.format("Cannot annotate method %s, with %s annotation. %s annotations must be placed on methods starting with 'get' or 'is'", method.getName(), fieldAnno.getClass().getName(), fieldAnno.getClass().getName()));
        }
        Class<?> datatype = method.getReturnType();
        return datatype;
    }

    private <T> String exportDataAccordingFieldAnnotation(T fixedFormatRecord, Method method, Field fieldAnno) {
        Object valueObject;
        Class datatype = this.getDatatype(method, fieldAnno);
        FormatContext context = this.getFormatContext(datatype, fieldAnno);
        FixedFormatter formatter = FixedFormatUtil.getFixedFormatterInstance(context.getFormatter(), context);
        FormatInstructions formatdata = this.getFormatInstructions(method, fieldAnno);
        try {
            valueObject = method.invoke(fixedFormatRecord, new Object[0]);
        }
        catch (Exception e) {
            throw new FixedFormatException(String.format("could not invoke method %s.%s(%s)", fixedFormatRecord.getClass().getName(), method.getName(), datatype), e);
        }
        String result = formatter.format(valueObject, formatdata);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("exported %s ", result));
        }
        return result;
    }

    private String stripMethodPrefix(String name) {
        if (name.startsWith("get") || name.startsWith("set")) {
            return name.substring(3);
        }
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        return name;
    }

    private FormatContext getFormatContext(Class datatype, Field fieldAnno) {
        FormatContext context = null;
        if (fieldAnno != null) {
            context = new FormatContext(fieldAnno.offset(), datatype, fieldAnno.formatter());
        }
        return context;
    }

    private FormatInstructions getFormatInstructions(Method method, Field fieldAnno) {
        FixedFormatPatternData patternData = this.getFixedFormatPatternData(method.getAnnotation(FixedFormatPattern.class));
        FixedFormatBooleanData booleanData = this.getFixedFormatBooleanData(method.getAnnotation(FixedFormatBoolean.class));
        FixedFormatNumberData numberData = this.getFixedFormatNumberData(method.getAnnotation(FixedFormatNumber.class));
        FixedFormatDecimalData decimalData = this.getFixedFormatDecimalData(method.getAnnotation(FixedFormatDecimal.class));
        return new FormatInstructions(fieldAnno.length(), fieldAnno.align(), fieldAnno.paddingChar(), patternData, booleanData, numberData, decimalData);
    }

    private FixedFormatPatternData getFixedFormatPatternData(FixedFormatPattern annotation) {
        FixedFormatPatternData result = annotation != null ? new FixedFormatPatternData(annotation.value()) : FixedFormatPatternData.DEFAULT;
        return result;
    }

    private FixedFormatBooleanData getFixedFormatBooleanData(FixedFormatBoolean annotation) {
        FixedFormatBooleanData result = annotation != null ? new FixedFormatBooleanData(annotation.trueValue(), annotation.falseValue()) : FixedFormatBooleanData.DEFAULT;
        return result;
    }

    private FixedFormatNumberData getFixedFormatNumberData(FixedFormatNumber annotation) {
        FixedFormatNumberData result = annotation != null ? new FixedFormatNumberData(annotation.sign(), annotation.positiveSign(), annotation.negativeSign()) : FixedFormatNumberData.DEFAULT;
        return result;
    }

    private FixedFormatDecimalData getFixedFormatDecimalData(FixedFormatDecimal annotation) {
        FixedFormatDecimalData result = annotation != null ? new FixedFormatDecimalData(annotation.decimals(), annotation.useDecimalDelimiter(), annotation.decimalDelimiter()) : FixedFormatDecimalData.DEFAULT;
        return result;
    }

    private boolean followsBeanStandard(Method method) {
        String methodName = method.getName();
        return methodName.startsWith("get") || methodName.startsWith("is");
    }
}

