/*
 * Decompiled with CFR 0.152.
 */
package com.ancientprogramming.fixedformat4j.format.impl;

import com.ancientprogramming.fixedformat4j.exception.FixedFormatException;
import com.ancientprogramming.fixedformat4j.format.AbstractFixedFormatter;
import com.ancientprogramming.fixedformat4j.format.FormatInstructions;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatter
extends AbstractFixedFormatter<Date> {
    @Override
    public Date asObject(String string, FormatInstructions instructions) throws FixedFormatException {
        Date result = null;
        if (!StringUtils.isEmpty(string)) {
            try {
                result = this.getFormatter(instructions.getFixedFormatPatternData().getPattern()).parse(string);
            }
            catch (ParseException e) {
                throw new FixedFormatException("Could not parse value[" + string + "] by pattern[" + instructions.getFixedFormatPatternData().getPattern() + "] to " + Date.class.getName());
            }
        }
        return result;
    }

    @Override
    public String asString(Date date, FormatInstructions instructions) {
        String result = null;
        if (date != null) {
            result = this.getFormatter(instructions.getFixedFormatPatternData().getPattern()).format(date);
        }
        return result;
    }

    DateFormat getFormatter(String pattern) {
        return new SimpleDateFormat(pattern);
    }
}

