/*
 * Decompiled with CFR 0.152.
 */
package com.ancientprogramming.fixedformat4j.format.impl;

import com.ancientprogramming.fixedformat4j.exception.FixedFormatException;
import com.ancientprogramming.fixedformat4j.format.FixedFormatter;
import com.ancientprogramming.fixedformat4j.format.FormatContext;
import com.ancientprogramming.fixedformat4j.format.FormatInstructions;
import com.ancientprogramming.fixedformat4j.format.impl.BigDecimalFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.BooleanFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.CharacterFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.DateFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.DoubleFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.FloatFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.IntegerFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.LongFormatter;
import com.ancientprogramming.fixedformat4j.format.impl.StringFormatter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByTypeFormatter
implements FixedFormatter {
    private FormatContext context;
    private static final Map<Class<? extends Serializable>, Class<? extends FixedFormatter>> KNOWN_FORMATTERS = new HashMap<Class<? extends Serializable>, Class<? extends FixedFormatter>>();

    public ByTypeFormatter(FormatContext context) {
        this.context = context;
    }

    public Object parse(String value, FormatInstructions instructions) {
        FixedFormatter formatter = this.actualFormatter(this.context.getDataType());
        return formatter.parse(value, instructions);
    }

    public String format(Object value, FormatInstructions instructions) {
        FixedFormatter formatter = this.actualFormatter(this.context.getDataType());
        return formatter.format(value, instructions);
    }

    public FixedFormatter actualFormatter(Class<? extends Object> dataType) {
        Class<? extends FixedFormatter> formatterClass = KNOWN_FORMATTERS.get(dataType);
        if (formatterClass != null) {
            try {
                return formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new FixedFormatException("Could not create instance of[" + formatterClass.getName() + "] because no default constructor exists");
            }
            catch (Exception e) {
                throw new FixedFormatException("Could not create instance of[" + formatterClass.getName() + "]", e);
            }
        }
        throw new FixedFormatException(ByTypeFormatter.class.getName() + " cannot handle datatype[" + dataType.getName() + "]. Provide your own custom FixedFormatter for this datatype.");
    }

    static {
        KNOWN_FORMATTERS.put(String.class, StringFormatter.class);
        KNOWN_FORMATTERS.put(Integer.TYPE, IntegerFormatter.class);
        KNOWN_FORMATTERS.put(Integer.class, IntegerFormatter.class);
        KNOWN_FORMATTERS.put(Long.TYPE, LongFormatter.class);
        KNOWN_FORMATTERS.put(Long.class, LongFormatter.class);
        KNOWN_FORMATTERS.put(Date.class, DateFormatter.class);
        KNOWN_FORMATTERS.put(Date.class, DateFormatter.class);
        KNOWN_FORMATTERS.put(Character.TYPE, CharacterFormatter.class);
        KNOWN_FORMATTERS.put(Character.class, CharacterFormatter.class);
        KNOWN_FORMATTERS.put(Boolean.TYPE, BooleanFormatter.class);
        KNOWN_FORMATTERS.put(Boolean.class, BooleanFormatter.class);
        KNOWN_FORMATTERS.put(Double.TYPE, DoubleFormatter.class);
        KNOWN_FORMATTERS.put(Double.class, DoubleFormatter.class);
        KNOWN_FORMATTERS.put(Float.TYPE, FloatFormatter.class);
        KNOWN_FORMATTERS.put(Float.class, FloatFormatter.class);
        KNOWN_FORMATTERS.put(BigDecimal.class, BigDecimalFormatter.class);
    }
}

