/*
 * Decompiled with CFR 0.152.
 */
package com.ancientprogramming.fixedformat4j.format.impl;

import com.ancientprogramming.fixedformat4j.exception.FixedFormatException;
import com.ancientprogramming.fixedformat4j.format.AbstractFixedFormatter;
import com.ancientprogramming.fixedformat4j.format.FormatInstructions;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanFormatter
extends AbstractFixedFormatter<Boolean> {
    @Override
    public Boolean asObject(String string, FormatInstructions instructions) throws FixedFormatException {
        Boolean result = false;
        if (!StringUtils.isEmpty(string)) {
            if (instructions.getFixedFormatBooleanData().getTrueValue().equals(string)) {
                result = true;
            } else if (instructions.getFixedFormatBooleanData().getFalseValue().equals(string)) {
                result = false;
            } else {
                throw new FixedFormatException("Could not convert string[" + string + "] to boolean value according to booleanData[" + instructions.getFixedFormatBooleanData() + "]");
            }
        }
        return result;
    }

    @Override
    public String asString(Boolean obj, FormatInstructions instructions) {
        String result = instructions.getFixedFormatBooleanData().getFalseValue();
        if (obj != null) {
            result = obj != false ? instructions.getFixedFormatBooleanData().getTrueValue() : instructions.getFixedFormatBooleanData().getFalseValue();
        }
        return result;
    }
}

