/*
 * Decompiled with CFR 0.152.
 */
package com.ancientprogramming.fixedformat4j.format.impl;

import com.ancientprogramming.fixedformat4j.format.FormatInstructions;
import com.ancientprogramming.fixedformat4j.format.impl.AbstractNumberFormatter;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDecimalFormatter<T>
extends AbstractNumberFormatter<T> {
    private static final Log LOG = LogFactory.getLog(AbstractDecimalFormatter.class);
    protected static final char DECIMAL_SEPARATOR;
    protected static final char GROUPING_SEPARATOR;
    protected static final String ZERO_STRING;
    protected static final DecimalFormat FORMATTER;

    @Override
    public String asString(T obj, FormatInstructions instructions) {
        String rawString;
        String string = rawString = obj != null ? FORMATTER.format(obj) : ZERO_STRING;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rawString: " + rawString + " - G[" + GROUPING_SEPARATOR + "] D[" + DECIMAL_SEPARATOR + "]"));
        }
        rawString = rawString.replaceAll("\\" + GROUPING_SEPARATOR, "");
        boolean useDecimalDelimiter = instructions.getFixedFormatDecimalData().isUseDecimalDelimiter();
        String beforeDelimiter = rawString.substring(0, rawString.indexOf(DECIMAL_SEPARATOR));
        String afterDelimiter = rawString.substring(rawString.indexOf(DECIMAL_SEPARATOR) + 1, rawString.length());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("beforeDelimiter[" + beforeDelimiter + "], afterDelimiter[" + afterDelimiter + "]"));
        }
        int decimals = instructions.getFixedFormatDecimalData().getDecimals();
        afterDelimiter = StringUtils.substring(afterDelimiter, 0, decimals);
        afterDelimiter = StringUtils.rightPad(afterDelimiter, decimals, '0');
        String delimiter = useDecimalDelimiter ? "" + instructions.getFixedFormatDecimalData().getDecimalDelimiter() : "";
        String result = beforeDelimiter + delimiter + afterDelimiter;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("result[" + result + "]"));
        }
        return result;
    }

    protected String getStringToConvert(String string, FormatInstructions instructions) {
        String toConvert;
        boolean useDecimalDelimiter = instructions.getFixedFormatDecimalData().isUseDecimalDelimiter();
        if (useDecimalDelimiter) {
            char delimiter = instructions.getFixedFormatDecimalData().getDecimalDelimiter();
            toConvert = string.replace(delimiter, '.');
        } else {
            int decimals = instructions.getFixedFormatDecimalData().getDecimals();
            if (decimals > 0 && string.length() >= decimals) {
                String beforeDelimiter = string.substring(0, string.length() - decimals);
                String afterDelimiter = string.substring(string.length() - decimals, string.length());
                toConvert = beforeDelimiter + '.' + afterDelimiter;
            } else {
                toConvert = string;
            }
        }
        return toConvert;
    }

    static {
        FORMATTER = new DecimalFormat();
        FORMATTER.setDecimalSeparatorAlwaysShown(true);
        DECIMAL_SEPARATOR = FORMATTER.getDecimalFormatSymbols().getDecimalSeparator();
        GROUPING_SEPARATOR = FORMATTER.getDecimalFormatSymbols().getGroupingSeparator();
        ZERO_STRING = "0" + DECIMAL_SEPARATOR + "0";
    }
}

