/*
 * Decompiled with CFR 0.152.
 */
package com.ancientprogramming.fixedformat4j.format;

import com.ancientprogramming.fixedformat4j.exception.FixedFormatException;
import com.ancientprogramming.fixedformat4j.format.FixedFormatter;
import com.ancientprogramming.fixedformat4j.format.FormatContext;
import com.ancientprogramming.fixedformat4j.format.FormatInstructions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedFormatUtil {
    private static final Log LOG = LogFactory.getLog(FixedFormatUtil.class);

    public static String fetchData(String record, FormatInstructions instructions, FormatContext context) {
        String result;
        int offset = context.getOffset() - 1;
        int length = instructions.getLength();
        if (record.length() >= offset + length) {
            result = record.substring(offset, offset + length);
        } else if (record.length() > offset) {
            result = record.substring(offset, record.length());
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)String.format("The record field was not as long as expected by the instructions. Expected field to be %s long but it was %s.", length, record.length()));
            }
        } else {
            result = null;
            LOG.warn((Object)String.format("Could not fetch data from record as the recordlength[%s] was shorter than or equal to the requested offset[%s] of the request data. Returning null", record.length(), offset));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("fetched '%s' from record", result));
        }
        return result;
    }

    public static FixedFormatter getFixedFormatterInstance(Class<? extends FixedFormatter> formatterClass, FormatContext context) {
        FixedFormatter formatter = FixedFormatUtil.getFixedFormatterInstance(formatterClass, context.getClass(), context);
        if (formatter == null) {
            formatter = FixedFormatUtil.getFixedFormatterInstance(formatterClass, null, null);
        }
        if (formatter == null) {
            throw new FixedFormatException("could not create instance of [" + formatterClass.getName() + "] because the class has no default constructor and no constructor with " + FormatContext.class.getName() + " as argument.");
        }
        return formatter;
    }

    public static FixedFormatter getFixedFormatterInstance(Class<? extends FixedFormatter> formatterClass, Class paramType, FormatContext paramValue) {
        FixedFormatter result;
        if (paramType != null && paramValue != null) {
            try {
                result = formatterClass.getConstructor(paramType).newInstance(paramValue);
            }
            catch (NoSuchMethodException e) {
                result = null;
            }
            catch (Exception e) {
                throw new FixedFormatException("Could not create instance with one argument constructor", e);
            }
        } else {
            try {
                result = formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                result = null;
            }
            catch (Exception e) {
                throw new FixedFormatException("Could not create instance with no arg constructor", e);
            }
        }
        return result;
    }
}

