/*
 * Decompiled with CFR 0.152.
 */
package com.ancientprogramming.fixedformat4j.annotation;

import com.ancientprogramming.fixedformat4j.format.FormatInstructions;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Sign {
    NOSIGN{

        public String apply(String value, FormatInstructions instructions) {
            return instructions.getAlignment().apply(value, instructions.getLength(), instructions.getPaddingChar());
        }

        public String remove(String value, FormatInstructions instructions) {
            String result = instructions.getAlignment().remove(value, instructions.getPaddingChar());
            if (StringUtils.isEmpty(result)) {
                result = "0";
            }
            return result;
        }
    }
    ,
    PREPEND{

        public String apply(String value, FormatInstructions instructions) {
            String sign = StringUtils.substring(value, 0, 1);
            if ("-".equals(sign)) {
                value = StringUtils.substring(value, 1);
            } else {
                sign = "+";
            }
            String result = instructions.getAlignment().apply(value, instructions.getLength(), instructions.getPaddingChar());
            return sign + StringUtils.substring(result, 1);
        }

        public String remove(String value, FormatInstructions instructions) {
            String sign = StringUtils.substring(value, 0, 1);
            String valueWithoutSign = StringUtils.substring(value, 1);
            String result = instructions.getAlignment().remove(valueWithoutSign, instructions.getPaddingChar());
            if (Sign.removeSign(instructions, sign, result)) {
                sign = "";
            }
            if (StringUtils.isEmpty(result)) {
                result = "0";
            }
            return sign + result;
        }
    }
    ,
    APPEND{

        public String apply(String value, FormatInstructions instructions) {
            String sign = StringUtils.substring(value, value.length() - 1, value.length());
            if ("-".equals(sign)) {
                value = StringUtils.substring(value, 0, value.length() - 1);
            } else {
                sign = "+";
            }
            String result = instructions.getAlignment().apply(value, instructions.getLength(), instructions.getPaddingChar());
            return StringUtils.substring(result, 1) + sign;
        }

        public String remove(String value, FormatInstructions instructions) {
            String sign = StringUtils.substring(value, value.length() - 1);
            String valueWithoutSign = StringUtils.substring(value, 0, value.length() - 1);
            String result = instructions.getAlignment().remove(valueWithoutSign, instructions.getPaddingChar());
            if (Sign.removeSign(instructions, sign, result)) {
                sign = "";
            }
            if (StringUtils.isEmpty(result)) {
                result = "0";
            }
            return sign + result;
        }
    };


    private static boolean removeSign(FormatInstructions instructions, String sign, String valueWithoutSign) {
        return instructions.getFixedFormatNumberData().getPositiveSign().equals(Character.valueOf(sign.charAt(0))) || StringUtils.isEmpty(valueWithoutSign) || "0".equals(valueWithoutSign);
    }

    public abstract String apply(String var1, FormatInstructions var2);

    public abstract String remove(String var1, FormatInstructions var2);
}

